/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting.advancement;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import de.siphalor.nbtcrafting.NbtCrafting;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2096;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3518;
import net.minecraft.class_4558;
import net.minecraft.class_5257;

public class StatChangedCriterion extends class_4558<StatChangedCriterion.Conditions<?>> {
	private static final class_2960 ID = new class_2960(NbtCrafting.MOD_ID, "stat_changed");

	@Override
	public class_2960 method_794() {
		return ID;
	}

	public <T> void trigger(class_3222 player, class_3445<T> stat, int value) {
		class_3448<T> statType = stat.method_14949();
		T object = stat.method_14951();

		method_22510(player, conditions -> conditions.match(statType, object, value));
	}

	@Override
	protected Conditions<?> method_27854(JsonObject obj, class_2048.class_5258 playerPredicate, class_5257 predicateDeserializer) {
		class_2960 statId = new class_2960(class_3518.method_15265(obj, "stat"));
		class_3448<?> statType = class_2378.field_11152.method_17966(statId).orElseThrow(() -> new JsonSyntaxException("Unknown stat: " + statId));

		class_2960 id = new class_2960(class_3518.method_15265(obj, "id"));
		Object object = statType.method_14959().method_10223(id);

		return new Conditions(statType, object, class_2096.class_2100.method_9056(obj.get("range")), playerPredicate);
	}

	static class Conditions<T> extends class_195 {
		private final class_3448<T> statType;
		private final T object;
		private final class_2096.class_2100 intRange;

		public Conditions(class_3448<T> statType, T object, class_2096.class_2100 intRange, class_2048.class_5258 playerPredicate) {
			super(ID, playerPredicate);
			this.statType = statType;
			this.object = object;
			this.intRange = intRange;
		}

		public boolean match(class_3448<?> statType, Object object, int value) {
			if (statType == this.statType && object == this.object) {
				return intRange.method_9054(value);
			}
			return false;
		}
	}
}
