/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting.client;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3956;
import net.minecraft.class_471;
import net.minecraft.class_634;
import de.siphalor.nbtcrafting.NbtCrafting;
import de.siphalor.nbtcrafting.mixin.RecipeManagerAccessor;
import de.siphalor.nbtcrafting.mixin.client.AnvilScreenAccessor;

public class NbtCraftingClient implements ClientModInitializer {
	@Override
	public void onInitializeClient() {
		ClientLoginNetworking.registerGlobalReceiver(NbtCrafting.PRESENCE_CHANNEL, (client, handler, buf, listenerAdder) -> {
			return CompletableFuture.completedFuture(new class_2540(Unpooled.buffer()));
		});

		ClientPlayNetworking.registerGlobalReceiver(NbtCrafting.UPDATE_ANVIL_TEXT_S2C_PACKET_ID, (client, handler, buf, responseSender) -> {
			if (class_310.method_1551().field_1755 instanceof class_471) {
				((AnvilScreenAccessor) class_310.method_1551().field_1755).getNameField().method_1852(buf.method_19772());
			} else
				buf.method_19772();
		});

		ClientPlayNetworking.registerGlobalReceiver(NbtCrafting.UPDATE_ADVANCED_RECIPES_PACKET_ID, NbtCraftingClient::receiveAdvancedRecipePacket);
	}

	private static synchronized void receiveAdvancedRecipePacket(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
		class_1863 recipeManager = handler.method_2877();
		Map<class_3956<?>, Map<class_2960, class_1860<?>>> recipeMap = ((RecipeManagerAccessor) recipeManager).getRecipes();
		recipeMap = new HashMap<>(recipeMap);

		NbtCrafting.advancedIngredientSerializationEnabled.set(true);
		int recipeCount = buf.method_10816();
		if (recipeCount == 0) {
			while (buf.isReadable()) {
				readRecipe(buf, recipeMap);
			}
		} else { // Legacy support
			for (int i = 0; i < recipeCount; i++) {
				readRecipe(buf, recipeMap);
			}
		}
		NbtCrafting.advancedIngredientSerializationEnabled.set(false);

		((RecipeManagerAccessor) recipeManager).setRecipes(ImmutableMap.copyOf(recipeMap));
	}

	private static void readRecipe(class_2540 buf, Map<class_3956<?>, Map<class_2960, class_1860<?>>> recipes) {
		class_1865<?> serializer = class_2378.field_17598.method_10223(buf.method_10810());
		if (serializer == null) {
			throw new IllegalStateException("Unknown recipe serializer on advanced recipe sync: " + buf.method_10810());
		}

		class_2960 id = buf.method_10810();

		class_1860<?> recipe = serializer.method_8122(id, buf);
		Map<class_2960, class_1860<?>> recipeType = recipes.computeIfAbsent(recipe.method_17716(), rt -> new HashMap<>());
		recipeType.put(id, recipe);
	}

	public static class_1863 getClientRecipeManager() {
		return class_310.method_1551().method_1562().method_2877();
	}
}
