/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting.ingredient;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.siphalor.nbtcrafting.api.nbt.NbtUtil;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;

public class IngredientEntryCondition {
	public static final IngredientEntryCondition EMPTY = new IngredientEntryCondition(NbtUtil.EMPTY_COMPOUND, NbtUtil.EMPTY_COMPOUND);

	public class_2487 requiredElements;
	public class_2487 deniedElements;

	public IngredientEntryCondition() {
		requiredElements = NbtUtil.EMPTY_COMPOUND;
		deniedElements = NbtUtil.EMPTY_COMPOUND;
	}

	public IngredientEntryCondition(class_2487 requiredElements, class_2487 deniedElements) {
		this.requiredElements = requiredElements;
		this.deniedElements = deniedElements;
	}

	public boolean matches(class_1799 stack) {
		if (!stack.method_7985()) {
			return requiredElements.method_33133();
		}
		class_2487 tag = stack.method_7969();
		//noinspection ConstantConditions
		if (!deniedElements.method_33133() && NbtUtil.compoundsOverlap(tag, deniedElements))
			return false;
		return requiredElements.method_33133() || NbtUtil.isCompoundContained(requiredElements, tag);
	}

	public void addToJson(JsonObject json) {
		if (requiredElements.method_10546() > 0)
			json.add("require", NbtUtil.toJson(requiredElements));
		if (deniedElements.method_10546() > 0)
			json.add("deny", NbtUtil.toJson(deniedElements));
	}

	public class_2487 getPreviewTag() {
		return requiredElements;
	}

	public static IngredientEntryCondition fromJson(JsonObject json) {
		IngredientEntryCondition condition = new IngredientEntryCondition();

		boolean flatObject = true;

		if (json.has("require")) {
			if (!json.get("require").isJsonObject())
				throw new JsonParseException("data.require must be an object");
			condition.requiredElements = (class_2487) NbtUtil.asTag(json.getAsJsonObject("require"));
			flatObject = false;
		}
		if (json.has("deny")) {
			if (!json.get("deny").isJsonObject())
				throw new JsonParseException("data.deny must be an object");
			condition.deniedElements = (class_2487) NbtUtil.asTag(json.getAsJsonObject("deny"));
			flatObject = false;
		}

		if (flatObject) {
			condition.requiredElements = (class_2487) NbtUtil.asTag(json);
		}

		return condition;
	}

	public void write(class_2540 buf) {
		buf.method_10794(requiredElements);
		buf.method_10794(deniedElements);
	}

	public static IngredientEntryCondition read(class_2540 buf) {
		return new IngredientEntryCondition(buf.method_10798(), buf.method_10798());
	}

}
