/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting.ingredient;

import java.util.Collection;
import java.util.Collections;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.siphalor.nbtcrafting.util.duck.IItemStack;

public class IngredientStackEntry extends IngredientEntry {

	private final IngredientEntryCondition condition;
	private final int id;

	public IngredientStackEntry(int id, IngredientEntryCondition condition) {
		super();
		this.id = id;
		this.condition = condition;
	}

	public IngredientStackEntry(class_1799 stack) {
		this.id = class_2378.field_11142.method_10206(stack.method_7909());
		if (stack.method_7985())
			this.condition = new IngredientEntryCondition(stack.method_7969(), new class_2487());
		else
			this.condition = new IngredientEntryCondition();
	}

	@Override
	public boolean matches(class_1799 stack) {
		return class_2378.field_11142.method_10206(stack.method_7909()) == this.id && condition.matches(stack);
	}

	@Override
	public JsonElement toJson() {
		JsonObject json = new JsonObject();
		json.addProperty("item", class_2378.field_11142.method_10221(class_2378.field_11142.method_10200(id)).toString());
		condition.addToJson(json);
		return json;
	}

	@Override
	public Collection<class_1799> getPreviewStacks(boolean nbt) {
		class_1799 stack = new class_1799(class_2378.field_11142.method_10200(id));
		if (nbt) {
			((IItemStack) (Object) stack).nbtCrafting$setRawTag(condition.getPreviewTag());
		}
		return Collections.singleton(stack);
	}

	@Override
	public void write(class_2540 buf) {
		buf.method_10804(id);
		this.condition.write(buf);
		buf.writeBoolean(remainder != null);
		if (remainder != null)
			buf.method_10793(remainder);
	}

	public static IngredientStackEntry read(class_2540 buf) {
		IngredientStackEntry entry = new IngredientStackEntry(buf.method_10816(), IngredientEntryCondition.read(buf));
		if (buf.readBoolean())
			entry.setRecipeRemainder(buf.method_10819());
		return entry;
	}

}
