/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import de.siphalor.nbtcrafting.NbtCrafting;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_3442;
import net.minecraft.class_3445;

@Mixin(class_3442.class)
public class MixinServerStatHandler {
	@Inject(method = "setStat", at = @At("TAIL"))
	public void setStat(class_1657 playerEntity, class_3445<?> stat, int value, CallbackInfo callbackInfo) {
		if (playerEntity instanceof class_3222) {
			NbtCrafting.STAT_CHANGED_CRITERION.trigger((class_3222) playerEntity, stat, value);
		}
	}
}
