/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting.mixin.brewing;

import java.util.Map;

import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1845;
import net.minecraft.class_1860;
import net.minecraft.class_2589;
import net.minecraft.class_2960;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import de.siphalor.nbtcrafting.NbtCrafting;
import de.siphalor.nbtcrafting.client.NbtCraftingClient;
import de.siphalor.nbtcrafting.mixin.RecipeManagerAccessor;
import de.siphalor.nbtcrafting.recipe.BrewingRecipe;

@Mixin(targets = "net/minecraft/screen/BrewingStandScreenHandler$IngredientSlot")
public abstract class MixinBrewingSlotIngredient extends class_1735 {
	public MixinBrewingSlotIngredient(class_1263 inventory_1, int int_1, int int_2, int int_3) {
		super(inventory_1, int_1, int_2, int_3);
	}

	@Inject(method = "canInsert(Lnet/minecraft/item/ItemStack;)Z", at = @At("RETURN"), cancellable = true)
	public void canInsert(class_1799 stack, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
		if (callbackInfoReturnable.getReturnValue() || class_1845.method_8077(stack)) {
			callbackInfoReturnable.setReturnValue(true);
			return;
		}
		RecipeManagerAccessor recipeManager;
		if (field_7871 instanceof class_2589) {
			recipeManager = (RecipeManagerAccessor) ((class_2589) field_7871).method_10997().method_8433();
		} else if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
			recipeManager = (RecipeManagerAccessor) NbtCraftingClient.getClientRecipeManager();
		} else {
			NbtCrafting.logError("Failed to get recipe manager in brewing stand container class!");
			return;
		}
		Map<class_2960, class_1860<class_1263>> recipes = recipeManager.callGetAllOfType(NbtCrafting.BREWING_RECIPE_TYPE);
		callbackInfoReturnable.setReturnValue(recipes.values().stream()
				.anyMatch(recipe -> recipe instanceof BrewingRecipe && ((BrewingRecipe) recipe).getIngredient().method_8093(stack))
		);
	}
}
