/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting.mixin.brewing;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2589;
import net.minecraft.class_2591;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_6088;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import de.siphalor.nbtcrafting.NbtCrafting;
import de.siphalor.nbtcrafting.api.RecipeUtil;
import de.siphalor.nbtcrafting.recipe.BrewingRecipe;

@SuppressWarnings("ConstantConditions")
@Mixin(class_2589.class)
public abstract class MixinBrewingStandBlockEntity extends class_2624 {
	@Unique
	private static class_1937 lastWorld;
	@Unique
	private static class_2589 lastBlockEntity;
	@Unique
	private static class_2338 lastBlockPos;

	protected MixinBrewingStandBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
		super(blockEntityType, blockPos, blockState);
	}

	@Inject(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/entity/BrewingStandBlockEntity;canCraft(Lnet/minecraft/util/collection/DefaultedList;)Z"))
	private static void beforeCanCraft(class_1937 world, class_2338 blockPos, class_2680 blockState, class_2589 blockEntity, CallbackInfo callbackInfo) {
		lastWorld = world;
		lastBlockEntity = blockEntity;
		lastBlockPos = blockPos;
	}

	@Inject(method = "canCraft", at = @At("HEAD"), cancellable = true)
	private static void canCraft(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
		Optional<BrewingRecipe> recipe = lastWorld.method_8433().method_8132(NbtCrafting.BREWING_RECIPE_TYPE, lastBlockEntity, lastWorld);
		if (recipe.isPresent()) {
			callbackInfoReturnable.setReturnValue(true);
		}
	}

	@Inject(method = "craft", at = @At("HEAD"), cancellable = true)
	private static void craft(class_1937 world, class_2338 pos, class_2371<class_1799> invList, CallbackInfo callbackInfo) {
		Optional<BrewingRecipe> recipe = lastWorld.method_8433().method_8132(NbtCrafting.BREWING_RECIPE_TYPE, lastBlockEntity, lastWorld);
		if (recipe.isPresent()) {
			class_2371<class_1799> remainingStacks = recipe.get().method_8111(lastBlockEntity);
			class_1799[] results = recipe.get().craftAll(lastBlockEntity);

			lastBlockEntity.method_5438(3).method_7934(1);
			for (int i = 0; i < 3; i++) {
				if (results[i] != null) {
					lastBlockEntity.method_5447(i, results[i]);
				}
			}

			RecipeUtil.putRemainders(remainingStacks, lastBlockEntity, lastWorld, lastBlockPos);

			world.method_20290(class_6088.field_31123, pos, 0);

			callbackInfo.cancel();
		}
	}

	@Inject(method = "isValid", at = @At("HEAD"), cancellable = true)
	public void isValidInvStack(int slotId, class_1799 stack, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
		if (slotId < 4 && method_5438(slotId).method_7960()) {
			if (stack.method_7909() != class_1802.field_8183) {
				callbackInfoReturnable.setReturnValue(true);
			}
		}
	}
}
