/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting.mixin.cooking;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import de.siphalor.nbtcrafting.util.duck.IItemStack;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_1874;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3957;

@Mixin(class_3957.class)
public abstract class MixinCookingRecipeSerializer {
	@Unique
	private class_2487 resultTag = null;

	@Redirect(method = "read(Lnet/minecraft/util/Identifier;Lcom/google/gson/JsonObject;)Lnet/minecraft/recipe/AbstractCookingRecipe;", at = @At(value = "INVOKE", target = "net/minecraft/util/JsonHelper.getString(Lcom/google/gson/JsonObject;Ljava/lang/String;)Ljava/lang/String;", ordinal = 0))
	public String getItemIdentifier(JsonObject jsonObject, String resultPropertyName) {
		resultTag = null;
		if (!jsonObject.has(resultPropertyName) || !jsonObject.get(resultPropertyName).isJsonObject()) {
			return class_3518.method_15265(jsonObject, resultPropertyName);
		}
		class_1799 output = class_1869.method_35228(jsonObject.getAsJsonObject(resultPropertyName));
		resultTag = output.method_7969();
		return class_2378.field_11142.method_10221(output.method_7909()).toString();
	}

	@Inject(method = "read(Lnet/minecraft/util/Identifier;Lcom/google/gson/JsonObject;)Lnet/minecraft/recipe/AbstractCookingRecipe;", at = @At(value = "TAIL"), locals = LocalCapture.CAPTURE_FAILHARD)
	public void onRecipeReady(class_2960 identifier, JsonObject jsonObject, CallbackInfoReturnable<class_1874> callbackInfoReturnable, String group, JsonElement ingredientJson, class_1856 ingredient, String itemId, class_2960 itemIdentifier, class_1799 stack, float experience, int cookingTime) {
		//noinspection ConstantConditions
		((IItemStack) (Object) stack).nbtCrafting$setRawTag(resultTag);
	}
}
