/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting.mixin.cutting;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import de.siphalor.nbtcrafting.api.RecipeUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_3972;

@Mixin(class_3972.class)
public class MixinCuttingRecipe {
	@Shadow
	@Final
	protected class_1799 output;

	@Shadow
	@Final
	protected class_1856 input;

	@Inject(method = "craft", at = @At("HEAD"), cancellable = true)
	public void craft(class_1263 inventory, CallbackInfoReturnable<class_1799> callbackInfoReturnable) {
		class_1799 result = RecipeUtil.getDollarAppliedResult(output, input, inventory);
		if (result != null)
			callbackInfoReturnable.setReturnValue(result);
	}
}
