/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting.mixin.cutting;

import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_3971;
import net.minecraft.class_3975;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import de.siphalor.nbtcrafting.api.nbt.NbtUtil;

@Mixin(class_3971.class)
public class MixinStonecutterContainer {
	@Shadow
	private List<class_3975> availableRecipes;

	@Inject(method = "updateInput", at = @At("TAIL"))
	private void onInputUpdated(class_1263 inventory, class_1799 input, CallbackInfo callbackInfo) {
		availableRecipes.sort((a, b) -> {
			class_1799 s1 = a.method_8110();
			class_1799 s2 = b.method_8110();
			int comp = s1.method_7922().compareTo(s2.method_7922());
			if (comp != 0)
				return comp;
			return NbtUtil.getTagOrEmpty(s1).toString().compareTo(NbtUtil.getTagOrEmpty(s2).toString());
		});
	}
}
