/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting.recipe;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import de.siphalor.nbtcrafting.NbtCrafting;
import de.siphalor.nbtcrafting.api.RecipeUtil;
import de.siphalor.nbtcrafting.api.nbt.NbtUtil;

public class BrewingRecipe extends IngredientRecipe<class_1263> {
	public static final class_1865<BrewingRecipe> SERIALIZER = new IngredientRecipe.Serializer<>(BrewingRecipe::new);

	public BrewingRecipe(class_2960 identifier, class_1856 base, class_1856 ingredient, class_1799 result, Serializer<BrewingRecipe> serializer) {
		super(identifier, base, ingredient, result, NbtCrafting.BREWING_RECIPE_TYPE, serializer);
	}

	@Override
	public boolean method_8115(class_1263 inv, class_1937 world) {
		if (ingredient.method_8093(inv.method_5438(3))) {
			for (int i = 0; i < 3; i++) {
				if (base.method_8093(inv.method_5438(i)))
					return true;
			}
		}
		return false;
	}

	public class_1799[] craftAll(class_1263 inv) {
		class_1799[] stacks = new class_1799[3];

		Map<String, Object> reference = new HashMap<>();
		reference.put("ingredient", NbtUtil.getTagOrEmpty(inv.method_5438(3)));

		for (int i = 0; i < 3; i++) {
			if (base.method_8093(inv.method_5438(i))) {
				reference.put("base", NbtUtil.getTagOrEmpty(inv.method_5438(i)));
				stacks[i] = RecipeUtil.applyDollars(result.method_7972(), resultDollars, reference);
			}
		}
		return stacks;
	}

	@Override
	public class_2371<class_1799> method_8111(class_1263 inv) {
		class_2371<class_1799> stacks = class_2371.method_10213(4, class_1799.field_8037);
		Map<String, Object> reference = new HashMap<>();
		reference.put("ingredient", NbtUtil.getTagOrEmpty(inv.method_5438(3)));
		stacks.set(3, RecipeUtil.getRemainder(inv.method_5438(3), ingredient, reference));

		for (int i = 0; i < 3; i++) {
			if (base.method_8093(inv.method_5438(i))) {
				reference.put("base", NbtUtil.getTagOrEmpty(inv.method_5438(i)));
				stacks.set(i, RecipeUtil.getRemainder(inv.method_5438(i), base, reference));
			}
		}
		return stacks;
	}
}
