/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import org.jetbrains.annotations.ApiStatus;

import de.siphalor.nbtcrafting.NbtCrafting;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

@ApiStatus.Experimental
public class WrappedRecipeSerializer implements class_1865<class_1860<?>> {
	private static long lastWarnTime = 0;

	@Override
	public class_1860<?> method_8121(class_2960 id, JsonObject json) {
		long time = System.currentTimeMillis();
		if (time > lastWarnTime + 30000) {
			NbtCrafting.logWarn("Some recipes are using the nbtcrafting:wrapped recipe type. This type is experimental and likely to change.");
		}
		lastWarnTime = time;

		JsonObject innerJson = class_3518.method_15296(json, "recipe");
		String innerType = class_3518.method_15265(innerJson, "type");
		class_1865<?> innerSerializer = class_2378.field_17598.method_10223(new class_2960(innerType));
		if (innerSerializer == null) {
			throw new JsonSyntaxException("Failed to resolve inner recipe type: " + innerType);
		}
		return innerSerializer.method_8121(id, innerJson);
	}

	@Override
	public class_1860<?> method_8122(class_2960 id, class_2540 buf) {
		throw new UnsupportedOperationException();
	}

	@Override
	public void method_8124(class_2540 buf, class_1860<?> recipe) {
		throw new UnsupportedOperationException();
	}
}
