/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.siphalor.nbtcrafting.NbtCrafting;
import de.siphalor.nbtcrafting.util.NumberUtil;
import java.util.Map;
import net.minecraft.class_3518;

public class JsonPreprocessor {
    private static final String STRINGIFY_KEY = "nbtcrafting:stringify";
    private static final String ARRAY_TYPE_KEY = "nbtcrafting:array_type=";

    public static JsonElement process(JsonElement jsonElement) {
        boolean marked = false;
        if (jsonElement instanceof JsonObject) {
            for (Map.Entry entry : ((JsonObject)jsonElement).entrySet()) {
                if (!((JsonElement)entry.getValue()).isJsonArray() && !((JsonElement)entry.getValue()).isJsonObject()) continue;
                ((JsonObject)jsonElement).add((String)entry.getKey(), JsonPreprocessor.process((JsonElement)entry.getValue()));
            }
            marked = class_3518.method_15258((JsonObject)((JsonObject)jsonElement), (String)"$stringify", (boolean)false);
            if (marked) {
                NbtCrafting.logWarn("The use of $stringify is deprecated, please use nbtcrafting:stringify instead");
            } else {
                marked = class_3518.method_15258((JsonObject)((JsonObject)jsonElement), (String)STRINGIFY_KEY, (boolean)false);
            }
        } else if (jsonElement instanceof JsonArray) {
            int i;
            int typeCast = -1;
            for (i = 0; i < ((JsonArray)jsonElement).size(); ++i) {
                JsonElement jsonArrayElement = ((JsonArray)jsonElement).get(i);
                if (!marked && jsonArrayElement instanceof JsonPrimitive && ((JsonPrimitive)jsonArrayElement).isString()) {
                    String key = jsonArrayElement.getAsString();
                    if (key.equals("$stringify")) {
                        NbtCrafting.logWarn("The use of $stringify is deprecated, please use nbtcrafting:stringify instead");
                        ((JsonArray)jsonElement).remove(i);
                        --i;
                        marked = true;
                        continue;
                    }
                    if (key.equals(STRINGIFY_KEY)) {
                        ((JsonArray)jsonElement).remove(i);
                        --i;
                        marked = true;
                        continue;
                    }
                    if (!key.startsWith(ARRAY_TYPE_KEY)) continue;
                    ((JsonArray)jsonElement).remove(i);
                    --i;
                    typeCast = NumberUtil.getType(key.substring(ARRAY_TYPE_KEY.length()));
                    continue;
                }
                if (!(jsonArrayElement instanceof JsonArray) && !(jsonArrayElement instanceof JsonObject)) continue;
                ((JsonArray)jsonElement).set(i, JsonPreprocessor.process(jsonArrayElement));
            }
            if (typeCast != -1) {
                for (i = 0; i < ((JsonArray)jsonElement).size(); ++i) {
                    if (!class_3518.method_15275((JsonElement)((JsonArray)jsonElement).get(i))) continue;
                    ((JsonArray)jsonElement).set(i, (JsonElement)new JsonPrimitive(NumberUtil.cast(((JsonArray)jsonElement).get(i).getAsNumber(), typeCast)));
                }
            }
        }
        if (marked) {
            return new JsonPrimitive(jsonElement.toString());
        }
        return jsonElement;
    }
}

