/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting.dollar.part.operator;

import de.siphalor.nbtcrafting.dollar.DollarEvaluationException;
import de.siphalor.nbtcrafting.dollar.DollarException;
import de.siphalor.nbtcrafting.dollar.DollarParser;
import de.siphalor.nbtcrafting.dollar.DollarUtil;
import de.siphalor.nbtcrafting.dollar.part.DollarPart;
import de.siphalor.nbtcrafting.dollar.part.ValueDollarPart;
import java.util.Map;

public class CastDollarOperator
implements DollarPart {
    private final DollarPart dollarPart;
    private final int typeId;

    private CastDollarOperator(DollarPart dollarPart, int typeId) {
        this.dollarPart = dollarPart;
        this.typeId = typeId;
    }

    public static DollarPart of(DollarPart dollarPart, int typeId) throws DollarException {
        CastDollarOperator instance = new CastDollarOperator(dollarPart, typeId);
        if (dollarPart.isConstant()) {
            return ValueDollarPart.of(instance.evaluate(null));
        }
        return instance;
    }

    @Override
    public Object evaluate(Map<String, Object> reference) throws DollarEvaluationException {
        Object value = this.dollarPart.evaluate(reference);
        switch (this.typeId) {
            case 100: {
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                return 0.0;
            }
            case 102: {
                if (value instanceof Number) {
                    return Float.valueOf(((Number)value).floatValue());
                }
                return Float.valueOf(0.0f);
            }
            case 67: 
            case 98: 
            case 99: {
                if (value instanceof Number) {
                    return ((Number)value).byteValue();
                }
                return (byte)0;
            }
            case 115: {
                if (value instanceof Number) {
                    return ((Number)value).shortValue();
                }
                return (short)0;
            }
            case 105: {
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                return 0;
            }
            case 108: {
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                return 0L;
            }
            case 66: {
                return DollarUtil.asBoolean(value);
            }
            case 34: 
            case 39: 
            case 83: 
            case 97: {
                return value.toString();
            }
        }
        return null;
    }

    public static class Deserializer
    implements DollarPart.Deserializer {
        @Override
        public boolean matches(int character, DollarParser dollarParser) {
            return character == 35;
        }

        @Override
        public DollarPart parse(DollarParser dollarParser, DollarPart lastDollarPart, int priority) {
            dollarParser.skip();
            return new CastDollarOperator(lastDollarPart, dollarParser.eat());
        }
    }
}

