/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting.dollar.part.operator;

import de.siphalor.nbtcrafting.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting.dollar.DollarDeserializationException;
import de.siphalor.nbtcrafting.dollar.DollarEvaluationException;
import de.siphalor.nbtcrafting.dollar.DollarParser;
import de.siphalor.nbtcrafting.dollar.part.DollarPart;
import de.siphalor.nbtcrafting.dollar.part.ValueDollarPart;
import de.siphalor.nbtcrafting.dollar.part.operator.BinaryDollarOperator;
import de.siphalor.nbtcrafting.util.NumberUtil;
import java.util.Collection;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class SumDollarOperator
extends BinaryDollarOperator {
    private SumDollarOperator(DollarPart first, DollarPart second) {
        super(first, second);
    }

    public static DollarPart of(DollarPart first, DollarPart second) throws DollarDeserializationException {
        SumDollarOperator instance = new SumDollarOperator(first, second);
        if (first.isConstant() && second.isConstant()) {
            try {
                return ValueDollarPart.of(instance.evaluate(null));
            }
            catch (DollarEvaluationException e) {
                throw new DollarDeserializationException(e);
            }
        }
        return instance;
    }

    @Override
    public Object apply(Object first, Object second) throws DollarEvaluationException {
        if ((first instanceof Number || first == null) && (second instanceof Number || second == null)) {
            return NumberUtil.sum((Number)first, (Number)second);
        }
        Object result = this.tryListSum(first, second);
        if (result != null) {
            return result;
        }
        if (first instanceof class_2487 && second instanceof class_2487) {
            result = ((class_2487)first).method_10553();
            NbtUtil.mergeInto((class_2487)result, (class_2487)second, true);
            return result;
        }
        return "" + first + second;
    }

    private Object tryListSum(Object first, Object second) throws DollarEvaluationException {
        if (first instanceof class_2499) {
            if (second == null) {
                return first;
            }
            if (second instanceof class_2499 && ((class_2499)first).method_10601() == ((class_2499)second).method_10601()) {
                class_2499 result = ((class_2499)first).method_10612();
                result.addAll((Collection)((class_2499)second));
                return result;
            }
            class_2520 secondTag = NbtUtil.asTag(second);
            if (((class_2499)first).method_10601() == secondTag.method_10711()) {
                class_2499 result = ((class_2499)first).method_10612();
                result.add((Object)secondTag);
                return result;
            }
            throw new DollarEvaluationException("Couldn't sum up list " + first.toString() + " with " + second.toString());
        }
        return first == null && second instanceof class_2499 ? second : null;
    }

    public static class Deserializer
    implements DollarPart.Deserializer {
        @Override
        public boolean matches(int character, DollarParser dollarParser) {
            return character == 43;
        }

        @Override
        public DollarPart parse(DollarParser dollarParser, DollarPart lastDollarPart, int priority) throws DollarDeserializationException {
            dollarParser.skip();
            if (lastDollarPart == null) {
                throw new DollarDeserializationException("Unexpected plus!");
            }
            return SumDollarOperator.of(lastDollarPart, dollarParser.parse(priority));
        }
    }
}

