/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.siphalor.nbtcrafting.ingredient.IngredientEntry;
import de.siphalor.nbtcrafting.ingredient.IngredientEntryCondition;
import de.siphalor.nbtcrafting.util.duck.IItemStack;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class IngredientMultiStackEntry
extends IngredientEntry {
    private final IngredientEntryCondition condition;
    private final IntList itemIds;
    private class_6862<class_1792> tag;

    public IngredientMultiStackEntry(Collection<Integer> items, IngredientEntryCondition condition) {
        this.condition = condition;
        this.itemIds = new IntArrayList(items);
        this.tag = null;
    }

    @Override
    public boolean matches(class_1799 stack) {
        return this.itemIds.contains(class_2378.field_11142.method_10206((Object)stack.method_7909())) && this.condition.matches(stack);
    }

    @Override
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("tag", this.tag.comp_327().toString());
        this.condition.addToJson(json);
        return json;
    }

    @Override
    public Collection<class_1799> getPreviewStacks(boolean nbt) {
        class_2487 tag = this.condition.getPreviewTag();
        ArrayList<class_1799> stacks = new ArrayList<class_1799>(this.itemIds.size());
        for (Integer id : this.itemIds) {
            class_1799 stack = new class_1799((class_1935)class_2378.field_11142.method_10200(id.intValue()));
            stacks.add(stack);
        }
        if (nbt) {
            for (class_1799 itemStack : stacks) {
                ((IItemStack)itemStack).nbtCrafting$setRawTag(tag);
            }
        }
        return stacks;
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10804(this.itemIds.size());
        for (int i = 0; i < this.itemIds.size(); ++i) {
            buf.method_10804(this.itemIds.getInt(i));
        }
        this.condition.write(buf);
        buf.writeBoolean(this.remainder != null);
        if (this.remainder != null) {
            buf.method_10793(this.remainder);
        }
    }

    public static IngredientMultiStackEntry read(class_2540 buf) {
        int length = buf.method_10816();
        ArrayList<Integer> ids = new ArrayList<Integer>(length);
        for (int i = 0; i < length; ++i) {
            ids.add(buf.method_10816());
        }
        IngredientMultiStackEntry entry = new IngredientMultiStackEntry(ids, IngredientEntryCondition.read(buf));
        if (buf.readBoolean()) {
            entry.setRecipeRemainder(buf.method_10819());
        }
        return entry;
    }

    public void setTag(String tag) {
        this.tag = class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960(tag));
    }
}

