/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting.mixin.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.siphalor.nbtcrafting.NbtCrafting;
import de.siphalor.nbtcrafting.api.JsonPreprocessor;
import de.siphalor.nbtcrafting.api.RecipeUtil;
import de.siphalor.nbtcrafting.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting.util.duck.IItemStack;
import net.minecraft.class_1263;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1869.class})
public abstract class MixinShapedRecipe {
    @Shadow
    @Final
    private class_1799 field_9053;
    @Shadow
    @Final
    private class_2371<class_1856> field_9052;

    @Inject(method={"outputFromJson"}, at={@At(value="HEAD")})
    private static void handlePotions(JsonObject json, CallbackInfoReturnable<class_1799> ci) {
        if (json.has("potion")) {
            JsonObject dataObject;
            class_2960 identifier = new class_2960(class_3518.method_15265((JsonObject)json, (String)"potion"));
            if (!class_2378.field_11143.method_17966(identifier).isPresent()) {
                throw new JsonParseException("The given resulting potion does not exist!");
            }
            if (!json.has("data")) {
                dataObject = new JsonObject();
                json.add("data", (JsonElement)dataObject);
            } else {
                dataObject = class_3518.method_15296((JsonObject)json, (String)"data");
            }
            dataObject.addProperty("Potion", identifier.toString());
            json.addProperty("item", "minecraft:potion");
        }
    }

    @Inject(method={"outputFromJson"}, at={@At(value="INVOKE", target="com/google/gson/JsonObject.has(Ljava/lang/String;)Z", remap=false)})
    private static void deserializeItemStack(JsonObject json, CallbackInfoReturnable<class_1799> ci) {
        NbtCrafting.clearLastReadNbt();
        if (json.has("data")) {
            if (class_3518.method_15289((JsonObject)json, (String)"data")) {
                try {
                    NbtCrafting.setLastReadNbt(new class_2522(new StringReader(json.get("data").getAsString())).method_10727());
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                NbtCrafting.setLastReadNbt((class_2487)NbtUtil.asTag(JsonPreprocessor.process((JsonElement)class_3518.method_15296((JsonObject)json, (String)"data"))));
            }
            json.remove("data");
        }
    }

    @Inject(method={"outputFromJson"}, at={@At(value="RETURN")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void constructDeserializedItemStack(JsonObject json, CallbackInfoReturnable<class_1799> ci, class_1792 item, int amount) {
        class_1799 stack = new class_1799((class_1935)item, amount);
        if (NbtCrafting.hasLastReadNbt()) {
            class_2487 lastReadNbt = NbtCrafting.useLastReadNbt();
            ((IItemStack)stack).nbtCrafting$setRawTag(lastReadNbt);
        }
        ci.setReturnValue((Object)stack);
    }

    @Inject(method={"craft"}, at={@At(value="HEAD")}, cancellable=true)
    public void craft(class_1715 craftingInventory, CallbackInfoReturnable<class_1799> callbackInfoReturnable) {
        class_1799 result = RecipeUtil.getDollarAppliedResult(this.field_9053, this.field_9052, (class_1263)craftingInventory);
        if (result != null) {
            callbackInfoReturnable.setReturnValue((Object)result);
        }
    }
}

