/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting.api;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import de.siphalor.nbtcrafting.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting.dollar.Dollar;
import de.siphalor.nbtcrafting.dollar.DollarException;
import de.siphalor.nbtcrafting.dollar.DollarParser;
import de.siphalor.nbtcrafting.ingredient.IIngredient;

public class RecipeUtil {
	@Deprecated
	public static class_1799 getDollarAppliedOutputStack(class_1799 baseOutput, class_2371<class_1856> ingredients, class_1263 inventory) {
		return getDollarAppliedResult(baseOutput, ingredients, inventory);
	}

	public static class_1799 getDollarAppliedResult(class_1799 baseOutput, class_2371<class_1856> ingredients, class_1263 inventory) {
		class_1799 stack = baseOutput.method_7972();
		Dollar[] dollars = DollarParser.extractDollars(stack.method_7969(), true);

		if (dollars.length > 0) {
			Map<String, Object> reference = new HashMap<>();
			ingredient:
			for (int j = 0; j < ingredients.size(); j++) {
				for (int i = 0; i < inventory.method_5439(); i++) {
					if (ingredients.get(j).method_8093(inventory.method_5438(i))) {
						reference.putIfAbsent("i" + j, NbtUtil.getTagOrEmpty(inventory.method_5438(i)));
						continue ingredient;
					}
				}
			}

			return applyDollars(stack, dollars, reference);
		}
		return stack;
	}

	@Deprecated
	public static class_1799 getDollarAppliedOutputStack(class_1799 baseOutput, class_1856 ingredient, class_1263 inventory) {
		return getDollarAppliedResult(baseOutput, ingredient, inventory);
	}

	public static class_1799 getDollarAppliedResult(class_1799 baseOutput, class_1856 ingredient, class_1263 inventory) {
		return getDollarAppliedResult(baseOutput, ingredient, "this", inventory);
	}

	@Deprecated
	public static class_1799 getDollarAppliedOutputStack(class_1799 baseOutput, class_1856 ingredient, String referenceName, class_1263 inventory) {
		return getDollarAppliedResult(baseOutput, ingredient, referenceName, inventory);
	}

	public static class_1799 getDollarAppliedResult(class_1799 baseOutput, class_1856 ingredient, String referenceName, class_1263 inventory) {
		class_1799 stack = baseOutput.method_7972();
		Dollar[] dollars = DollarParser.extractDollars(stack.method_7969(), true);

		if (dollars.length > 0) {
			Map<String, Object> reference = new HashMap<>();
			reference.put(referenceName, NbtUtil.getTagOrEmpty(inventory.method_5438(0)));

			return applyDollars(stack, dollars, reference);
		}
		return stack;
	}

	public static class_1799 getRemainder(class_1799 itemStack, class_1856 ingredient, Map<String, Object> reference) {
		class_1799 result = ((IIngredient) (Object) ingredient).nbtCrafting$getRecipeRemainder(itemStack, reference);
		if (result == null) {
			return new class_1799(itemStack.method_7909().method_7858());
		}
		return result;
	}

	public static void putRemainders(class_2371<class_1799> remainders, class_1263 target, class_1937 world, class_2338 scatterPos) {
		putRemainders(remainders, target, world, scatterPos, 0);
	}

	public static void putRemainders(class_2371<class_1799> remainders, class_1263 target, class_1937 world, class_2338 scatterPos, int offset) {
		final int size = remainders.size();
		if (size > target.method_5439()) {
			throw new IllegalArgumentException("Size of given remainder list must be <= size of target inventory");
		}
		for (int i = 0; i < size; i++) {
			if (target.method_5438(offset + i).method_7960()) {
				target.method_5447(offset + i, remainders.get(i));
				remainders.set(i, class_1799.field_8037);
			}
		}
		class_1264.method_17349(world, scatterPos, remainders);
	}

	public static class_1799 applyDollars(class_1799 stack, Dollar[] dollars, Map<String, Object> reference) {
		for (Dollar dollar : dollars) {
			try {
				dollar.apply(stack, reference);
			} catch (DollarException e) {
				e.printStackTrace();
			}
		}
		if (stack.method_7919() > stack.method_7936()) {
			return class_1799.field_8037;
		}
		return stack;
	}
}
