/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting.dollar.part;

public class ValueDollarPart extends ConstantDollarPart {
	private final Object value;

	private ValueDollarPart(Object value) {
		this.value = value;
	}

	public static ValueDollarPart of(Object value) {
		return new ValueDollarPart(value);
	}

	@Override
	public boolean isConstant() {
		return true;
	}

	@Override
	public Object getValue() {
		return value;
	}
}
