/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting.mixin;

import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2955;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_2955.class)
public abstract class MixinInputSlotFiller {
	@Shadow
	protected class_1661 inventory;

	@Redirect(method = "fillInputSlot", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerInventory;indexOf(Lnet/minecraft/item/ItemStack;)I"))
	private int playerInventoryFindStack(class_1661 inventory, class_1799 stack) {
		for (int i = 0; i < inventory.field_7547.size(); i++) {
			class_1799 stack2 = inventory.field_7547.get(i);
			if (stack.method_7909() == stack2.method_7909() && class_1799.method_7975(stack, stack2))
				return i;
		}
		if (!stack.method_7985()) {
			for (int i = 0; i < inventory.field_7547.size(); i++) {
				class_1799 stack2 = inventory.field_7547.get(i);
				if (stack2.method_7985() && stack.method_7962(stack2))
					return i;
			}
		}
		return -1;
	}
}
