/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting.mixin.smithing;

import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import net.minecraft.class_4862;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import de.siphalor.nbtcrafting.NbtCrafting;
import de.siphalor.nbtcrafting.api.RecipeUtil;
import de.siphalor.nbtcrafting.recipe.IngredientRecipe;

@Mixin(class_4862.class)
public abstract class MixinSmithingScreenHandler extends class_4861 {
	@Unique
	private static class_2371<class_1799> remainders = null;

	public MixinSmithingScreenHandler(class_3917<?> type, int syncId, class_1661 playerInventory, class_3914 context) {
		super(type, syncId, playerInventory, context);
	}

	@Inject(
			method = "updateResult",
			at = @At("HEAD"),
			cancellable = true
	)
	public void onUpdateResult(CallbackInfo callbackInfo) {
		Optional<IngredientRecipe<class_1263>> match = field_22482.field_6002.method_8433().method_8132(NbtCrafting.SMITHING_RECIPE_TYPE, field_22480, field_22482.field_6002);

		if (match.isPresent()) {
			field_22479.method_5447(0, match.get().method_8116(field_22480));
			callbackInfo.cancel();
		}
	}

	@Inject(
			method = "canTakeOutput",
			at = @At("HEAD"),
			cancellable = true
	)
	protected void canTakeOutput(class_1657 playerEntity, boolean stackPresent, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
		if (stackPresent) {
			callbackInfoReturnable.setReturnValue(true);
		}
	}

	@Inject(
			method = "onTakeOutput",
			at = @At("HEAD")
	)
	protected void onTakeOutput(class_1657 player, class_1799 stack, CallbackInfo ci) {
		Optional<IngredientRecipe<class_1263>> match = player.field_6002.method_8433().method_8132(NbtCrafting.SMITHING_RECIPE_TYPE, field_22480, player.field_6002);
		remainders = match.map(inventoryIngredientRecipe -> inventoryIngredientRecipe.method_8111(field_22480)).orElse(null);
	}

	@Inject(
			method = "onTakeOutput",
			at = @At("TAIL")
	)
	protected void onOutputTaken(class_1657 player, class_1799 stack, CallbackInfo ci) {
		if (remainders != null) {
			field_22481.method_17393((world, blockPos) -> {
				RecipeUtil.putRemainders(remainders, field_22480, world, blockPos);
			});
		}
	}
}
