/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting.recipe.cauldron;

import com.google.gson.JsonObject;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class CauldronRecipeSerializer implements class_1865<CauldronRecipe> {
	@Override
	public CauldronRecipe method_8121(class_2960 identifier, JsonObject jsonObject) {
		JsonObject output = class_3518.method_15296(jsonObject, "result");
		int levels = 0;
		class_2960 fluid = null;
		if (jsonObject.has("levels")) {
			levels = jsonObject.get("levels").getAsInt();
			if (jsonObject.has("fluid")) {
				fluid = new class_2960(jsonObject.get("fluid").getAsString());
			} else {
				fluid = TemporaryCauldronInventory.WATER;
			}
		}
		return new CauldronRecipe(identifier, class_1856.method_8102(jsonObject.get("input")), class_1869.method_35228(output), fluid, levels);
	}

	@Override
	public CauldronRecipe method_8122(class_2960 identifier, class_2540 packetByteBuf) {
		return CauldronRecipe.from(packetByteBuf);
	}

	@Override
	public void write(class_2540 packetByteBuf, CauldronRecipe cauldronRecipe) {
		cauldronRecipe.write(packetByteBuf);
	}
}
