/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting.recipe.cauldron;

import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5556;

public class TemporaryCauldronInventory implements class_1263 {
	public static final class_2960 AIR = new class_2960("air");
	public static final class_2960 WATER = new class_2960("water");
	public static final class_2960 LAVA = new class_2960("lava");
	public static final class_2960 POWDER_SNOW = new class_2960("powder_snow");

	private class_1799 stackInHand;
	private final class_1657 playerEntity;
	private final class_1268 hand;
	private final class_2960 fluid;
	private int level;
	private final class_1937 world;
	private final class_2338 blockPos;

	public TemporaryCauldronInventory(class_1657 playerEntity, class_1268 hand, class_1937 world, class_2338 blockPos) {
		this.playerEntity = playerEntity;
		this.hand = hand;
		this.world = world;
		this.blockPos = blockPos;
		stackInHand = playerEntity.method_5998(hand);
		class_2680 blockState = world.method_8320(blockPos);
		if (blockState.method_26204() == class_2246.field_27097) {
			fluid = WATER;
			level = blockState.method_11654(class_5556.field_27206);
		} else if (blockState.method_26204() == class_2246.field_27878) {
			fluid = POWDER_SNOW;
			level = blockState.method_11654(class_5556.field_27206);
		} else if (blockState.method_26204() == class_2246.field_27098) {
			fluid = LAVA;
			level = 3;
		} else if (blockState.method_26204() == class_2246.field_10593) {
			fluid = AIR;
			level = 0;
		} else {
			fluid = null;
			level = 0;
		}
	}

	public class_2960 getFluid() {
		return fluid;
	}

	public int getLevel() {
		return level;
	}

	public void setLevel(int level) {
		if (level <= 0) { // The cauldron needs to be cleared
			this.level = 0;
			world.method_8501(blockPos, class_2246.field_10593.method_9564());
			return;
		}
		if (fluid == WATER || fluid == POWDER_SNOW) {
			if (this.level <= 0) { // It was an empty cauldron before so we're replacing it
				class_2248 block = fluid == WATER ? class_2246.field_27097 : class_2246.field_27878;
				world.method_8501(blockPos, block.method_9564().method_11657(class_5556.field_27206, Math.min(level, 3)));
			} else { // There was a water cauldron before so we're reusing it (mod compat.)
				world.method_8501(blockPos, world.method_8320(blockPos).method_11657(class_5556.field_27206, Math.min(level, 3)));
			}
		} else if (fluid == LAVA && this.level <= 0) { // There was an empty cauldron before so we're replacing it
			world.method_8501(blockPos, class_2246.field_27098.method_9564());
		}
		this.level = level;
	}

	public int getMaxLevel() {
		return 3;
	}

	@Override
	public int method_5439() {
		return 1;
	}

	@Override
	public boolean method_5442() {
		return stackInHand.method_7960();
	}

	@Override
	public class_1799 method_5438(int var1) {
		return stackInHand;
	}

	@Override
	public class_1799 method_5434(int var1, int var2) {
		return stackInHand.method_7971(var2);
	}

	@Override
	public class_1799 method_5441(int var1) {
		playerEntity.method_6122(hand, class_1799.field_8037);
		class_1799 result = stackInHand;
		stackInHand = class_1799.field_8037;
		return result;
	}

	@Override
	public void method_5447(int var1, class_1799 var2) {
		playerEntity.method_6122(hand, var2);
	}

	@Override
	public void method_5431() {
		playerEntity.method_31548().method_5431();
	}

	@Override
	public boolean method_5443(class_1657 var1) {
		return playerEntity == var1;
	}

	@Override
	public void method_5448() {
		method_5441(0);
	}
}
