/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting.api.nbt;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import de.siphalor.nbtcrafting.NbtCrafting;
import de.siphalor.nbtcrafting.api.nbt.MergeMode;
import de.siphalor.nbtcrafting.api.nbt.NbtException;
import de.siphalor.nbtcrafting.api.nbt.NbtNumberRange;
import de.siphalor.nbtcrafting.util.BetterJsonOps;
import java.util.Collection;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_2481;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2509;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Contract;

public class NbtUtil {
    public static final class_2487 EMPTY_COMPOUND = new class_2487();

    public static class_2487 getTagOrEmpty(class_1799 itemStack) {
        if (itemStack.method_7985()) {
            return itemStack.method_7969();
        }
        return EMPTY_COMPOUND;
    }

    public static class_2487 copyOrEmpty(class_2487 compoundTag) {
        if (compoundTag == null) {
            return new class_2487();
        }
        return compoundTag.method_10553();
    }

    public static boolean tagsMatch(class_2520 main, class_2520 reference) {
        if (NbtUtil.isString(reference) && reference.method_10714().equals("")) {
            return true;
        }
        if (NbtUtil.isString(main) && NbtUtil.isString(reference)) {
            return main.method_10714().equals(reference.method_10714());
        }
        if (NbtUtil.isNumeric(main)) {
            if (NbtUtil.isNumeric(reference)) {
                return NbtUtil.asNumberTag(main).method_10697() == NbtUtil.asNumberTag(reference).method_10697();
            }
            if (NbtUtil.isString(reference) && reference.method_10714().startsWith("$")) {
                return NbtNumberRange.ofString(reference.method_10714().substring(1)).matches(NbtUtil.asNumberTag(main).method_10697());
            }
            return false;
        }
        return false;
    }

    public static boolean compoundsOverlap(class_2487 main, class_2487 reference) {
        for (String key : main.method_10541()) {
            if (!reference.method_10545(key)) continue;
            class_2520 mainTag = main.method_10580(key);
            class_2520 refTag = reference.method_10580(key);
            if (!(NbtUtil.isCompound(mainTag) && NbtUtil.isCompound(refTag) ? NbtUtil.compoundsOverlap(main.method_10562(key), reference.method_10562(key)) : (NbtUtil.isList(mainTag) && NbtUtil.isList(refTag) ? NbtUtil.listsOverlap(NbtUtil.asListTag(main.method_10580(key)), NbtUtil.asListTag(reference.method_10580(key))) : NbtUtil.tagsMatch(main.method_10580(key), reference.method_10580(key))))) continue;
            return true;
        }
        return false;
    }

    public static boolean listsOverlap(class_2483<class_2520> main, class_2483<class_2520> reference) {
        for (class_2520 mainTag : main) {
            for (class_2520 referenceTag : main) {
                if (!(NbtUtil.isCompound(mainTag) && NbtUtil.isCompound(referenceTag) ? NbtUtil.compoundsOverlap(NbtUtil.asCompoundTag(mainTag), NbtUtil.asCompoundTag(referenceTag)) : (NbtUtil.isList(mainTag) && NbtUtil.isList(referenceTag) ? NbtUtil.listsOverlap(NbtUtil.asListTag(mainTag), NbtUtil.asListTag(referenceTag)) : NbtUtil.tagsMatch(mainTag, referenceTag)))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCompoundContained(class_2487 inner, class_2487 outer) {
        for (String key : inner.method_10541()) {
            class_2520 innerTag = inner.method_10580(key);
            if (!outer.method_10545(key)) {
                return false;
            }
            class_2520 outerTag = outer.method_10580(key);
            if (NbtUtil.isCompound(innerTag) && NbtUtil.isCompound(outerTag)) {
                if (NbtUtil.isCompoundContained(NbtUtil.asCompoundTag(innerTag), NbtUtil.asCompoundTag(outerTag))) continue;
                return false;
            }
            if (NbtUtil.isList(innerTag) && NbtUtil.isList(outerTag)) {
                if (NbtUtil.isListContained(NbtUtil.asListTag(innerTag), NbtUtil.asListTag(outerTag))) continue;
                return false;
            }
            if (NbtUtil.tagsMatch(outerTag, innerTag)) continue;
            return false;
        }
        return true;
    }

    public static boolean isListContained(class_2483<class_2520> inner, class_2483<class_2520> outer) {
        for (class_2520 innerTag : inner) {
            boolean success = false;
            for (class_2520 outerTag : outer) {
                if (NbtUtil.isCompound(innerTag) && NbtUtil.isCompound(outerTag) && NbtUtil.isCompoundContained(NbtUtil.asCompoundTag(innerTag), NbtUtil.asCompoundTag(outerTag))) {
                    success = true;
                    break;
                }
                if (NbtUtil.isList(innerTag) && NbtUtil.isList(outerTag) && NbtUtil.isListContained(NbtUtil.asListTag(innerTag), NbtUtil.asListTag(outerTag))) {
                    success = true;
                    break;
                }
                if (!NbtUtil.tagsMatch(innerTag, outerTag)) continue;
                success = true;
                break;
            }
            if (success) continue;
            return false;
        }
        return true;
    }

    public static boolean sameType(class_2520 tag1, class_2520 tag2) {
        return tag1.method_10711() == tag2.method_10711();
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isString(class_2520 tag) {
        return tag instanceof class_2519;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isCompound(class_2520 tag) {
        return tag instanceof class_2487;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isList(class_2520 tag) {
        return tag instanceof class_2483;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNumeric(class_2520 tag) {
        return tag instanceof class_2514;
    }

    public static String asString(class_2520 tag) {
        if (tag instanceof class_2514) {
            return ((class_2514)tag).method_10702().toString();
        }
        if (tag instanceof class_2519) {
            return tag.method_10714();
        }
        if (tag instanceof class_2499) {
            StringJoiner joiner = new StringJoiner(", ");
            for (class_2520 entry : (class_2499)tag) {
                String s = NbtUtil.asString(entry);
                joiner.add(s);
            }
            return joiner.toString();
        }
        return tag.toString();
    }

    public static class_2519 asStringTag(class_2520 tag) {
        return (class_2519)tag;
    }

    public static class_2487 asCompoundTag(class_2520 tag) {
        return (class_2487)tag;
    }

    public static class_2483<class_2520> asListTag(class_2520 tag) {
        return (class_2483)tag;
    }

    public static class_2514 asNumberTag(class_2520 tag) {
        return (class_2514)tag;
    }

    public static class_2520 getTag(class_2520 main, String path) {
        return NbtUtil.getTag(main, NbtUtil.splitPath(path));
    }

    public static class_2520 getTag(class_2520 main, String[] pathKeys) {
        class_2520 currentTag = main;
        for (String pathKey : pathKeys) {
            if ("".equals(pathKey)) continue;
            if (currentTag == null) {
                return null;
            }
            if (pathKey.charAt(0) == '[') {
                int index = Integer.parseUnsignedInt(pathKey.substring(1, pathKey.length() - 2), 10);
                if (NbtUtil.isList(currentTag)) {
                    class_2483<class_2520> list = NbtUtil.asListTag(currentTag);
                    if (index >= list.size()) {
                        return null;
                    }
                    currentTag = (class_2520)list.get(index);
                    continue;
                }
                return null;
            }
            if (NbtUtil.isCompound(currentTag)) {
                class_2487 compound = NbtUtil.asCompoundTag(currentTag);
                if (compound.method_10545(pathKey)) {
                    currentTag = compound.method_10580(pathKey);
                    continue;
                }
                return null;
            }
            return null;
        }
        return currentTag;
    }

    public static class_2520 getTagOrCreate(class_2520 main, String path) throws NbtException {
        return NbtUtil.getTagOrCreate(main, NbtUtil.splitPath(path));
    }

    public static class_2520 getTagOrCreate(class_2520 main, String[] pathParts) throws NbtException {
        class_2520 currentTag = main;
        for (String pathPart : pathParts) {
            if ("".equals(pathPart)) continue;
            if (pathPart.charAt(0) == '[') {
                if (!NbtUtil.isList(currentTag)) {
                    throw new NbtException(String.join((CharSequence)".", pathParts) + " doesn't match on " + main.method_10714());
                }
                class_2483<class_2520> currentList = NbtUtil.asListTag(currentTag);
                int index = Integer.parseUnsignedInt(pathPart.substring(1, pathPart.length() - 1));
                if (currentList.size() <= index) {
                    throw new NbtException(String.join((CharSequence)".", pathParts) + " contains invalid list in " + main.method_10714());
                }
                if (NbtUtil.isCompound((class_2520)currentList.get(index)) || NbtUtil.isList((class_2520)currentList.get(index))) {
                    currentTag = (class_2520)currentList.get(index);
                    continue;
                }
                throw new NbtException(String.join((CharSequence)".", pathParts) + " doesn't match on " + main.method_10714());
            }
            if (!NbtUtil.isCompound(currentTag)) {
                throw new NbtException(String.join((CharSequence)".", pathParts) + " doesn't match on " + main.method_10714());
            }
            class_2487 currentCompound = NbtUtil.asCompoundTag(currentTag);
            if (!currentCompound.method_10545(pathPart)) {
                class_2487 newCompound = new class_2487();
                currentCompound.method_10566(pathPart, (class_2520)newCompound);
                currentTag = newCompound;
                continue;
            }
            if (NbtUtil.isCompound(currentCompound.method_10580(pathPart)) || NbtUtil.isList(currentCompound.method_10580(pathPart))) {
                currentTag = currentCompound.method_10580(pathPart);
                continue;
            }
            throw new NbtException(String.join((CharSequence)".", pathParts) + " doesn't match on " + main.method_10714());
        }
        return currentTag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void put(class_2520 main, String[] pathParts, class_2520 tag) throws NbtException {
        class_2520 parent = NbtUtil.getTagOrCreate(main, (String[])ArrayUtils.subarray((Object[])pathParts, (int)0, (int)(pathParts.length - 1)));
        String key = pathParts[pathParts.length - 1];
        if (key.charAt(0) == '[') {
            int i = Integer.parseUnsignedInt(key.substring(1, key.length() - 1));
            if (!NbtUtil.isList(parent)) throw new NbtException(String.join((CharSequence)".", pathParts) + " doesn't match on " + main.method_10714());
            if (tag == null) {
                NbtUtil.asListTag(parent).method_10536(i);
                return;
            } else {
                try {
                    NbtUtil.asListTag(parent).method_10531(i, tag);
                    return;
                }
                catch (Exception e) {
                    throw new NbtException("Can't add tag " + tag.method_10714() + " to list: " + parent.method_10714());
                }
            }
        } else {
            if (!NbtUtil.isCompound(parent)) throw new NbtException(String.join((CharSequence)".", pathParts) + " doesn't match on " + main.method_10714());
            if (tag == null) {
                NbtUtil.asCompoundTag(parent).method_10551(key);
                return;
            } else {
                NbtUtil.asCompoundTag(parent).method_10566(key, tag);
            }
        }
    }

    public static String[] splitPath(String path) {
        return path.split("\\.|(?=\\[)");
    }

    public static String getLastKey(String path) {
        return path.substring(path.lastIndexOf(46) + 1);
    }

    public static void mergeInto(class_2487 target, class_2487 additions, boolean replace) {
        if (additions == null) {
            return;
        }
        for (String key : additions.method_10541()) {
            if (!target.method_10545(key)) {
                target.method_10566(key, additions.method_10580(key).method_10707());
                continue;
            }
            class_2520 targetTag = target.method_10580(key);
            class_2520 additionsTag = additions.method_10580(key);
            if (NbtUtil.isCompound(targetTag) && NbtUtil.isCompound(additionsTag)) {
                NbtUtil.mergeInto(NbtUtil.asCompoundTag(targetTag), NbtUtil.asCompoundTag(additionsTag), replace);
                continue;
            }
            if (NbtUtil.isList(targetTag) && NbtUtil.isList(additionsTag)) {
                int targetSize = NbtUtil.asListTag(targetTag).size();
                class_2483<class_2520> listTag = NbtUtil.asListTag(targetTag);
                for (class_2520 tag : NbtUtil.asListTag(additionsTag)) {
                    class_2520 copy = tag.method_10707();
                    listTag.add((Object)tag);
                }
                continue;
            }
            if (!replace) continue;
            target.method_10566(key, additionsTag.method_10707());
        }
    }

    public static void mergeInto(class_2487 target, class_2487 additions, Collection<Pair<Pattern, MergeMode>> mergeModes, String basePath) {
        if (additions == null) {
            return;
        }
        if (!((String)basePath).isEmpty()) {
            basePath = (String)basePath + ".";
        }
        for (String key : additions.method_10541()) {
            String path = (String)basePath + key;
            MergeMode mergeMode = NbtUtil.getMergeMode(mergeModes, path);
            if (target.method_10545(key)) {
                if (mergeMode == MergeMode.UPDATE || mergeMode == MergeMode.OVERWRITE) {
                    target.method_10566(key, additions.method_10580(key).method_10707());
                    continue;
                }
                if (mergeMode != MergeMode.MERGE) continue;
                class_2520 targetTag = target.method_10580(key);
                class_2520 additionsTag = additions.method_10580(key);
                if (NbtUtil.isCompound(targetTag) && NbtUtil.isCompound(additionsTag)) {
                    NbtUtil.mergeInto(NbtUtil.asCompoundTag(targetTag), NbtUtil.asCompoundTag(additionsTag), mergeModes, path);
                    continue;
                }
                if (NbtUtil.isList(targetTag) && NbtUtil.isList(additionsTag)) {
                    NbtUtil.mergeInto(NbtUtil.asListTag(targetTag), NbtUtil.asListTag(additionsTag), mergeModes, path);
                    continue;
                }
                target.method_10566(key, additionsTag.method_10707());
                continue;
            }
            if (mergeMode == MergeMode.UPDATE) continue;
            target.method_10566(key, additions.method_10580(key).method_10707());
        }
    }

    public static void mergeInto(class_2483<class_2520> target, class_2483<class_2520> additions, Collection<Pair<Pattern, MergeMode>> mergeModes, String basePath) {
        int i;
        if (additions == null) {
            return;
        }
        int targetSize = target.size();
        int additionsSize = additions.size();
        for (i = 0; i < additions.size() && i < targetSize; ++i) {
            String path = basePath + "[" + i + "]";
            MergeMode mergeMode = NbtUtil.getMergeMode(mergeModes, path);
            if (mergeMode == MergeMode.OVERWRITE || mergeMode == MergeMode.UPDATE) {
                target.method_10606(i, ((class_2520)additions.get(i)).method_10707());
                continue;
            }
            if (mergeMode == MergeMode.MERGE) {
                class_2520 targetTag = (class_2520)target.get(i);
                class_2520 additionsTag = (class_2520)additions.get(i);
                if (NbtUtil.isCompound(targetTag) && NbtUtil.isCompound(additionsTag)) {
                    NbtUtil.mergeInto(NbtUtil.asCompoundTag(targetTag), NbtUtil.asCompoundTag(additionsTag), mergeModes, path);
                    continue;
                }
                if (NbtUtil.isList(targetTag) && NbtUtil.isList(additionsTag)) {
                    NbtUtil.mergeInto(NbtUtil.asListTag(targetTag), NbtUtil.asListTag(additionsTag), mergeModes, path);
                    continue;
                }
                target.method_10606(i, targetTag.method_10707());
                continue;
            }
            if (mergeMode != MergeMode.APPEND) continue;
            try {
                target.add((Object)((class_2520)additions.get(i)).method_10707());
                continue;
            }
            catch (Exception e) {
                NbtCrafting.logError("Can't append tag " + ((class_2520)additions.get(i)).method_10714() + " to list: " + target.method_10714());
            }
        }
        for (i = targetSize; i < additionsSize; ++i) {
            MergeMode mergeMode = NbtUtil.getMergeMode(mergeModes, basePath + "[" + i + "]");
            if (mergeMode == MergeMode.UPDATE) continue;
            target.add((Object)((class_2520)additions.get(i)));
        }
    }

    public static MergeMode getMergeMode(Collection<Pair<Pattern, MergeMode>> mergeModes, String path) {
        for (Pair<Pattern, MergeMode> entry : mergeModes) {
            if (!((Pattern)entry.getFirst()).matcher(path).matches()) continue;
            return (MergeMode)((Object)entry.getSecond());
        }
        return MergeMode.MERGE;
    }

    public static class_2520 asTag(Object value) {
        if (value instanceof class_2520) {
            return (class_2520)value;
        }
        if (value instanceof String) {
            return class_2519.method_23256((String)((String)value));
        }
        if (value instanceof Float) {
            return class_2494.method_23244((float)((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return class_2489.method_23241((double)((Double)value));
        }
        if (value instanceof Byte) {
            return class_2481.method_23233((byte)((Byte)value));
        }
        if (value instanceof Character) {
            return class_2519.method_23256((String)String.valueOf(value));
        }
        if (value instanceof Short) {
            return class_2516.method_23254((short)((Short)value));
        }
        if (value instanceof Integer) {
            return class_2497.method_23247((int)((Integer)value));
        }
        if (value instanceof Long) {
            return class_2503.method_23251((long)((Long)value));
        }
        if (value instanceof Boolean) {
            return class_2481.method_23233((byte)((byte)((Boolean)value != false ? 1 : 0)));
        }
        return null;
    }

    public static Object toDollarValue(class_2520 value) {
        if (value instanceof class_2519) {
            return value.method_10714();
        }
        if (value instanceof class_2494) {
            return Float.valueOf(((class_2494)value).method_10700());
        }
        if (value instanceof class_2489) {
            return ((class_2489)value).method_10697();
        }
        if (value instanceof class_2481) {
            return ((class_2481)value).method_10698();
        }
        if (value instanceof class_2516) {
            return ((class_2516)value).method_10696();
        }
        if (value instanceof class_2497) {
            return ((class_2497)value).method_10701();
        }
        if (value instanceof class_2503) {
            return ((class_2503)value).method_10699();
        }
        if (value instanceof class_2520) {
            return value;
        }
        return null;
    }

    public static class_2520 asTag(JsonElement jsonElement) {
        return (class_2520)Dynamic.convert((DynamicOps)BetterJsonOps.INSTANCE, (DynamicOps)class_2509.field_11560, (Object)jsonElement);
    }

    public static JsonElement toJson(class_2520 tag) {
        return (JsonElement)Dynamic.convert((DynamicOps)class_2509.field_11560, (DynamicOps)BetterJsonOps.INSTANCE, (Object)tag);
    }
}

