/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting.dollar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import de.siphalor.nbtcrafting.NbtCrafting;
import de.siphalor.nbtcrafting.api.nbt.MergeMode;
import de.siphalor.nbtcrafting.api.nbt.NbtIterator;
import de.siphalor.nbtcrafting.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting.dollar.Dollar;
import de.siphalor.nbtcrafting.dollar.DollarDeserializationException;
import de.siphalor.nbtcrafting.dollar.DollarException;
import de.siphalor.nbtcrafting.dollar.part.DollarPart;
import de.siphalor.nbtcrafting.dollar.part.operator.CastDollarOperator;
import de.siphalor.nbtcrafting.dollar.part.operator.ChildDollarOperator;
import de.siphalor.nbtcrafting.dollar.part.operator.ConditionDollarOperator;
import de.siphalor.nbtcrafting.dollar.part.operator.DifferenceDollarOperator;
import de.siphalor.nbtcrafting.dollar.part.operator.ProductDollarOperator;
import de.siphalor.nbtcrafting.dollar.part.operator.QuotientDollarOperator;
import de.siphalor.nbtcrafting.dollar.part.operator.SumDollarOperator;
import de.siphalor.nbtcrafting.dollar.part.unary.CombinationDollarPartDeserializer;
import de.siphalor.nbtcrafting.dollar.part.unary.InverseDollarOperator;
import de.siphalor.nbtcrafting.dollar.part.unary.NumberDollarPartDeserializer;
import de.siphalor.nbtcrafting.dollar.part.unary.ReferenceDollarPart;
import de.siphalor.nbtcrafting.dollar.part.unary.StringDollarPartDeserializer;
import de.siphalor.nbtcrafting.dollar.type.CountDollar;
import de.siphalor.nbtcrafting.dollar.type.MergeDollar;
import de.siphalor.nbtcrafting.dollar.type.SimpleDollar;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.regex.Pattern;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.apache.commons.lang3.ArrayUtils;

public final class DollarParser {
    private static final Collection<DollarPart.UnaryDeserializer> UNARY_DESERIALIZERS = ImmutableList.of((Object)new CombinationDollarPartDeserializer(), (Object)new InverseDollarOperator.Deserializer(), (Object)new NumberDollarPartDeserializer(), (Object)new ReferenceDollarPart.Deserializer(), (Object)new StringDollarPartDeserializer());
    private static final List<Collection<DollarPart.Deserializer>> DESERIALIZERS = ImmutableList.of((Object)ImmutableList.of((Object)new CastDollarOperator.Deserializer(), (Object)new ChildDollarOperator.DotDeserializer(), (Object)new ChildDollarOperator.BracketDeserializer()), (Object)ImmutableList.of((Object)new ProductDollarOperator.Deserializer(), (Object)new QuotientDollarOperator.Deserializer()), (Object)ImmutableList.of((Object)new SumDollarOperator.Deserializer(), (Object)new DifferenceDollarOperator.Deserializer()), (Object)ImmutableList.of((Object)new ConditionDollarOperator.Deserializer()));
    private final Stack<Integer> stopStack = new Stack();
    private final String string;
    private final int stringLength;
    private int currentIndex;

    public DollarParser(String string) {
        this.string = string;
        this.stringLength = string.length();
        this.currentIndex = -1;
    }

    public int eat() {
        if (this.currentIndex++ >= this.stringLength) {
            return -1;
        }
        return this.string.codePointAt(this.currentIndex);
    }

    public void skip() {
        ++this.currentIndex;
    }

    public int peek() {
        if (this.currentIndex + 1 >= this.stringLength) {
            return -1;
        }
        return this.string.codePointAt(this.currentIndex + 1);
    }

    public static Dollar[] extractDollars(class_2487 compoundTag, boolean remove) {
        LinkedList dollars = new LinkedList();
        NbtIterator.iterateTags((class_2520)compoundTag, (path, key, tag) -> {
            if (key.equals("$")) {
                if (NbtUtil.isList(tag)) {
                    class_2483<class_2520> list = NbtUtil.asListTag(tag);
                    for (class_2520 t : list) {
                        DollarParser.parseMerge(t, path).ifPresent(dollars::addFirst);
                    }
                } else {
                    DollarParser.parseMerge(tag, path).ifPresent(dollars::addFirst);
                }
                return remove;
            }
            if (NbtUtil.isString(tag) && !tag.method_10714().isEmpty() && tag.method_10714().charAt(0) == '$') {
                if (key.equals("nbtcrafting:count")) {
                    DollarParser.parse(tag.method_10714().substring(1)).ifPresent(exp -> dollars.addFirst(new CountDollar((DollarPart)exp)));
                } else {
                    DollarParser.parse(tag.method_10714().substring(1)).ifPresent(exp -> dollars.addFirst(new SimpleDollar((DollarPart)exp, path + key)));
                }
                return remove;
            }
            return false;
        });
        dollars.sort((a, b) -> {
            if (a instanceof MergeDollar) {
                return b instanceof MergeDollar ? 0 : -1;
            }
            return 1;
        });
        return dollars.toArray(new Dollar[0]);
    }

    private static Optional<MergeDollar> parseMerge(class_2520 tag, String path) {
        if (NbtUtil.isString(tag)) {
            String val = tag.method_10714();
            if (val.charAt(0) == '$') {
                val = val.substring(1);
            }
            return DollarParser.parse(val).map(exp -> new MergeDollar((DollarPart)exp, path, (Collection<Pair<Pattern, MergeMode>>)Collections.emptyList()));
        }
        if (NbtUtil.isCompound(tag)) {
            class_2487 compound = NbtUtil.asCompoundTag(tag);
            if (compound.method_10573("value", 8)) {
                LinkedList<Pair> mergeModes = new LinkedList<Pair>();
                if (compound.method_10573("paths", 10)) {
                    class_2487 paths = compound.method_10562("paths");
                    for (String p : paths.method_10541()) {
                        try {
                            MergeMode mergeMode = MergeMode.valueOf(paths.method_10580(p).method_10714().toUpperCase(Locale.ENGLISH));
                            if (p.startsWith("/") && p.endsWith("/")) {
                                mergeModes.add(Pair.of((Object)Pattern.compile(Pattern.quote(path) + "\\.?" + p.substring(1, p.length() - 1)), (Object)((Object)mergeMode)));
                                continue;
                            }
                            mergeModes.add(Pair.of((Object)Pattern.compile(Pattern.quote(path) + "\\.?" + Pattern.quote(p)), (Object)((Object)mergeMode)));
                        }
                        catch (Exception e) {
                            NbtCrafting.logError("Unable to deduce dollar merge mode from tag: " + paths.method_10580(p));
                        }
                    }
                }
                return DollarParser.parse(compound.method_10558("value")).map(exp -> new MergeDollar((DollarPart)exp, path, (Collection<Pair<Pattern, MergeMode>>)mergeModes));
            }
            NbtCrafting.logError("The value field is required on dollar merge objects. Errored on " + tag.method_10714());
        } else {
            NbtCrafting.logError("Found invalid dollar merge tag: " + tag.method_10714());
        }
        return Optional.empty();
    }

    public static Optional<DollarPart> parse(String string) {
        return Optional.ofNullable(new DollarParser(string).parse());
    }

    public DollarPart parse() {
        try {
            return this.parse(DESERIALIZERS.size());
        }
        catch (DollarException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void pushStopStack(int stop) {
        this.stopStack.push(stop);
    }

    public void popStopStack() {
        this.stopStack.pop();
    }

    public DollarPart parse(int maxPriority) throws DollarDeserializationException {
        int peek;
        DollarPart dollarPart = this.parseUnary();
        block0: while (true) {
            if (Character.isWhitespace(peek = this.peek())) {
                this.skip();
                continue;
            }
            if (peek == -1) {
                return dollarPart;
            }
            if (!this.stopStack.isEmpty() && (Integer)this.stopStack.lastElement() == peek) {
                return dollarPart;
            }
            int priority = 0;
            for (Collection<DollarPart.Deserializer> deserializers : DESERIALIZERS) {
                if (++priority > maxPriority) break block0;
                for (DollarPart.Deserializer deserializer : deserializers) {
                    if (!deserializer.matches(peek, this)) continue;
                    dollarPart = deserializer.parse(this, dollarPart, priority);
                    continue block0;
                }
            }
            break;
        }
        if (maxPriority < DESERIALIZERS.size()) {
            return dollarPart;
        }
        throw new DollarDeserializationException("Unable to resolve token in dollar expression: \"" + String.valueOf(Character.toChars(peek)) + "\"");
    }

    public DollarPart parseUnary() throws DollarDeserializationException {
        int peek;
        while (Character.isWhitespace(peek = this.peek())) {
            this.skip();
        }
        if (peek == -1) {
            return null;
        }
        for (DollarPart.UnaryDeserializer deserializer : UNARY_DESERIALIZERS) {
            if (!deserializer.matches(peek, this)) continue;
            return deserializer.parse(this);
        }
        return null;
    }

    public DollarPart parseTo(int stop) {
        this.pushStopStack(stop);
        DollarPart dollarPart = this.parse();
        this.popStopStack();
        this.skip();
        return dollarPart;
    }

    public String readTo(int ... stops) {
        int character;
        boolean escaped = false;
        StringBuilder stringBuilder = new StringBuilder();
        while (!ArrayUtils.contains((int[])stops, (int)(character = this.eat()))) {
            if (character == -1) {
                return null;
            }
            if (escaped) {
                stringBuilder.append(Character.toChars(character));
                escaped = false;
                continue;
            }
            if (character == 92) {
                escaped = true;
                continue;
            }
            stringBuilder.append(Character.toChars(character));
        }
        return stringBuilder.toString();
    }

    public static void main(String[] args) {
        DollarParser.parse("a + b").flatMap(dollarPart -> {
            try {
                class_2499 a = new class_2499();
                a.add((Object)new class_2499());
                class_2499 b = new class_2499();
                b.add((Object)new class_2499());
                return Optional.of(dollarPart.evaluate((Map<String, Object>)ImmutableMap.of((Object)"a", (Object)a, (Object)"b", (Object)b)));
            }
            catch (DollarException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }).ifPresent(System.out::println);
    }
}

