/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting.dollar.part.operator;

import de.siphalor.nbtcrafting.dollar.DollarDeserializationException;
import de.siphalor.nbtcrafting.dollar.DollarException;
import de.siphalor.nbtcrafting.dollar.DollarParser;
import de.siphalor.nbtcrafting.dollar.part.DollarPart;
import de.siphalor.nbtcrafting.dollar.part.ValueDollarPart;
import de.siphalor.nbtcrafting.dollar.part.operator.BinaryDollarOperator;
import de.siphalor.nbtcrafting.util.NumberUtil;
import org.apache.commons.lang3.StringUtils;

public class ProductDollarOperator
extends BinaryDollarOperator {
    public ProductDollarOperator(DollarPart first, DollarPart second) {
        super(first, second);
    }

    public static DollarPart of(DollarPart first, DollarPart second) throws DollarException {
        ProductDollarOperator instance = new ProductDollarOperator(first, second);
        if (first.isConstant() && second.isConstant()) {
            return ValueDollarPart.of(instance.evaluate(null));
        }
        return null;
    }

    @Override
    public Object apply(Object first, Object second) {
        if (first instanceof Number || first == null) {
            first = NumberUtil.denullify((Number)first);
            if (second instanceof Number || second == null) {
                return NumberUtil.product((Number)first, (Number)second);
            }
            return StringUtils.repeat((String)second.toString(), (int)((Number)first).intValue());
        }
        if (second instanceof Number || second == null) {
            return StringUtils.repeat((String)first.toString(), (int)NumberUtil.denullify((Number)second).intValue());
        }
        return null;
    }

    public static class Deserializer
    implements DollarPart.Deserializer {
        @Override
        public boolean matches(int character, DollarParser dollarParser) {
            return character == 42;
        }

        @Override
        public DollarPart parse(DollarParser dollarParser, DollarPart lastDollarPart, int priority) throws DollarDeserializationException {
            if (lastDollarPart == null) {
                throw new DollarDeserializationException("Unexpected asterisk!");
            }
            dollarParser.skip();
            return new ProductDollarOperator(lastDollarPart, dollarParser.parse(priority));
        }
    }
}

