/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting.dollar.part.unary;

import de.siphalor.nbtcrafting.dollar.DollarEvaluationException;
import de.siphalor.nbtcrafting.dollar.DollarParser;
import de.siphalor.nbtcrafting.dollar.part.DollarPart;
import java.util.Map;

public class ReferenceDollarPart
implements DollarPart {
    private final String key;

    private ReferenceDollarPart(String key) {
        this.key = key;
    }

    public static DollarPart of(String key) {
        return new ReferenceDollarPart(key);
    }

    @Override
    public Object evaluate(Map<String, Object> reference) throws DollarEvaluationException {
        if (!reference.containsKey(this.key)) {
            throw new DollarEvaluationException("Could not resolve reference to nbt tag '" + this.key + "'");
        }
        return reference.get(this.key);
    }

    public static class Deserializer
    implements DollarPart.UnaryDeserializer {
        @Override
        public boolean matches(int character, DollarParser dollarParser) {
            return Character.isJavaIdentifierStart(character);
        }

        @Override
        public DollarPart parse(DollarParser dollarParser) {
            int character;
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Character.toChars(dollarParser.eat())));
            while (Character.isJavaIdentifierPart(character = dollarParser.peek())) {
                dollarParser.skip();
                stringBuilder.append(Character.toChars(character));
            }
            return ReferenceDollarPart.of(stringBuilder.toString());
        }
    }
}

