/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.siphalor.nbtcrafting.api.nbt.NbtUtil;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public class IngredientEntryCondition {
    public static final IngredientEntryCondition EMPTY = new IngredientEntryCondition(NbtUtil.EMPTY_COMPOUND, NbtUtil.EMPTY_COMPOUND);
    public class_2487 requiredElements;
    public class_2487 deniedElements;

    public IngredientEntryCondition() {
        this.requiredElements = NbtUtil.EMPTY_COMPOUND;
        this.deniedElements = NbtUtil.EMPTY_COMPOUND;
    }

    public IngredientEntryCondition(class_2487 requiredElements, class_2487 deniedElements) {
        this.requiredElements = requiredElements;
        this.deniedElements = deniedElements;
    }

    public boolean matches(class_1799 stack) {
        if (!stack.method_7985()) {
            return this.requiredElements.method_33133();
        }
        class_2487 tag = stack.method_7969();
        if (!this.deniedElements.method_33133() && NbtUtil.compoundsOverlap(tag, this.deniedElements)) {
            return false;
        }
        return this.requiredElements.method_33133() || NbtUtil.isCompoundContained(this.requiredElements, tag);
    }

    public void addToJson(JsonObject json) {
        if (this.requiredElements.method_10546() > 0) {
            json.add("require", NbtUtil.toJson((class_2520)this.requiredElements));
        }
        if (this.deniedElements.method_10546() > 0) {
            json.add("deny", NbtUtil.toJson((class_2520)this.deniedElements));
        }
    }

    public class_2487 getPreviewTag() {
        return this.requiredElements;
    }

    public static IngredientEntryCondition fromJson(JsonObject json) {
        IngredientEntryCondition condition = new IngredientEntryCondition();
        boolean flatObject = true;
        if (json.has("require")) {
            if (!json.get("require").isJsonObject()) {
                throw new JsonParseException("data.require must be an object");
            }
            condition.requiredElements = (class_2487)NbtUtil.asTag((JsonElement)json.getAsJsonObject("require"));
            flatObject = false;
        }
        if (json.has("deny")) {
            if (!json.get("deny").isJsonObject()) {
                throw new JsonParseException("data.deny must be an object");
            }
            condition.deniedElements = (class_2487)NbtUtil.asTag((JsonElement)json.getAsJsonObject("deny"));
            flatObject = false;
        }
        if (flatObject) {
            condition.requiredElements = (class_2487)NbtUtil.asTag((JsonElement)json);
        }
        return condition;
    }

    public void write(class_2540 buf) {
        buf.method_10794(this.requiredElements);
        buf.method_10794(this.deniedElements);
    }

    public static IngredientEntryCondition read(class_2540 buf) {
        return new IngredientEntryCondition(buf.method_10798(), buf.method_10798());
    }
}

