/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.siphalor.nbtcrafting.api.RecipeUtil;
import de.siphalor.nbtcrafting.api.ServerRecipe;
import de.siphalor.nbtcrafting.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting.api.recipe.NBTCRecipe;
import de.siphalor.nbtcrafting.dollar.Dollar;
import de.siphalor.nbtcrafting.dollar.DollarParser;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;

public class IngredientRecipe<I extends class_1263>
implements NBTCRecipe<I>,
ServerRecipe {
    private final class_2960 identifier;
    protected final class_1856 base;
    protected final class_1856 ingredient;
    protected final class_1799 result;
    protected final Dollar[] resultDollars;
    protected final class_3956<? extends IngredientRecipe<I>> recipeType;
    protected final class_1865<? extends IngredientRecipe<I>> serializer;

    public IngredientRecipe(class_2960 identifier, class_1856 base, class_1856 ingredient, class_1799 result, class_3956<? extends IngredientRecipe<I>> recipeType, class_1865<? extends IngredientRecipe<I>> serializer) {
        this.identifier = identifier;
        this.base = base;
        this.ingredient = ingredient;
        this.result = result;
        this.resultDollars = DollarParser.extractDollars(result.method_7969(), false);
        this.recipeType = recipeType;
        this.serializer = serializer;
    }

    public boolean method_8115(I inv, class_1937 world) {
        if (this.ingredient != null && this.ingredient.method_8093(inv.method_5438(1))) {
            return this.base.method_8093(inv.method_5438(0));
        }
        return false;
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    public class_1799 method_8116(I inv) {
        return RecipeUtil.applyDollars(this.result.method_7972(), this.resultDollars, this.buildDollarReference(inv));
    }

    public class_1799 method_8110() {
        return this.result;
    }

    public class_2960 method_8114() {
        return this.identifier;
    }

    public class_1856 getBase() {
        return this.base;
    }

    public class_1856 getIngredient() {
        return this.ingredient;
    }

    public class_2371<class_1856> method_8117() {
        return class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{this.base, this.ingredient});
    }

    public class_3956<?> method_17716() {
        return this.recipeType;
    }

    public class_1865<? extends IngredientRecipe<I>> method_8119() {
        return this.serializer;
    }

    @Override
    public Map<String, Object> buildDollarReference(I inv) {
        return ImmutableMap.of((Object)"base", (Object)NbtUtil.getTagOrEmpty(inv.method_5438(0)), (Object)"ingredient", (Object)NbtUtil.getTagOrEmpty(inv.method_5438(1)));
    }

    public void readCustomData(JsonObject json) {
    }

    public void readCustomData(class_2540 buf) {
    }

    public void writeCustomData(class_2540 buf) {
    }

    public static class Serializer<R extends IngredientRecipe<?>>
    implements class_1865<R> {
        private final Factory<R> factory;

        public Serializer(Factory<R> factory) {
            this.factory = factory;
        }

        public R read(class_2960 id, JsonObject json) {
            class_1856 base = class_1856.method_8102((JsonElement)json.get("base"));
            class_1856 ingredient = json.has("ingredient") ? class_1856.method_8102((JsonElement)json.get("ingredient")) : class_1856.field_9017;
            class_1799 result = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            R recipe = this.factory.create(id, base, ingredient, result, this);
            ((IngredientRecipe)recipe).readCustomData(json);
            return recipe;
        }

        public R read(class_2960 id, class_2540 buf) {
            class_1856 base = class_1856.method_8086((class_2540)buf);
            class_1856 ingredient = class_1856.method_8086((class_2540)buf);
            class_1799 result = buf.method_10819();
            R recipe = this.factory.create(id, base, ingredient, result, this);
            ((IngredientRecipe)recipe).readCustomData(buf);
            return recipe;
        }

        public void write(class_2540 buf, R recipe) {
            ((IngredientRecipe)recipe).base.method_8088(buf);
            ((IngredientRecipe)recipe).ingredient.method_8088(buf);
            buf.method_10793(((IngredientRecipe)recipe).result);
            ((IngredientRecipe)recipe).writeCustomData(buf);
        }
    }

    public static interface Factory<R extends IngredientRecipe<?>> {
        public R create(class_2960 var1, class_1856 var2, class_1856 var3, class_1799 var4, Serializer<R> var5);
    }
}

