/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting.recipe.cauldron;

import com.google.common.collect.ImmutableMap;
import de.siphalor.nbtcrafting.NbtCrafting;
import de.siphalor.nbtcrafting.api.RecipeUtil;
import de.siphalor.nbtcrafting.api.ServerRecipe;
import de.siphalor.nbtcrafting.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting.api.recipe.NBTCRecipe;
import de.siphalor.nbtcrafting.dollar.Dollar;
import de.siphalor.nbtcrafting.dollar.DollarParser;
import de.siphalor.nbtcrafting.recipe.cauldron.TemporaryCauldronInventory;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;

public class CauldronRecipe
implements NBTCRecipe<TemporaryCauldronInventory>,
ServerRecipe {
    private final class_2960 identifier;
    public final class_1856 input;
    public final class_1799 output;
    public final class_2960 fluid;
    public final int levels;
    private final Dollar[] outputDollars;

    public CauldronRecipe(class_2960 id, class_1856 ingredient, class_1799 output, class_2960 fluid, int levels) {
        this.identifier = id;
        this.input = ingredient;
        this.output = output;
        this.fluid = fluid;
        this.levels = levels;
        this.outputDollars = DollarParser.extractDollars(output.method_7969(), false);
    }

    public void write(class_2540 packetByteBuf) {
        packetByteBuf.method_10812(this.identifier);
        this.input.method_8088(packetByteBuf);
        packetByteBuf.method_10793(this.output);
        packetByteBuf.method_10812(this.fluid);
        packetByteBuf.writeShort(this.levels);
    }

    public static CauldronRecipe from(class_2540 packetByteBuf) {
        class_2960 identifier = packetByteBuf.method_10810();
        class_1856 input = class_1856.method_8086((class_2540)packetByteBuf);
        class_1799 output = packetByteBuf.method_10819();
        class_2960 fluid = packetByteBuf.method_10810();
        short levels = packetByteBuf.readShort();
        return new CauldronRecipe(identifier, input, output, fluid, levels);
    }

    public boolean matches(TemporaryCauldronInventory inventory, class_1937 world) {
        if (this.fluid != null && !this.fluid.equals((Object)inventory.getFluid())) {
            return false;
        }
        if (!this.input.method_8093(inventory.method_5438(0))) {
            return false;
        }
        if (this.levels >= 0) {
            return inventory.getLevel() >= this.levels;
        }
        return inventory.getMaxLevel() - inventory.getLevel() >= -this.levels;
    }

    public class_1799 craft(TemporaryCauldronInventory inventory) {
        inventory.setLevel(inventory.getLevel() - this.levels);
        inventory.method_5438(0).method_7934(1);
        return RecipeUtil.applyDollars(this.output.method_7972(), this.outputDollars, this.buildDollarReference(inventory));
    }

    public boolean method_8113(int i, int i1) {
        return false;
    }

    public class_1799 method_8110() {
        return this.output;
    }

    public class_2371<class_1856> method_8117() {
        return class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{this.input});
    }

    public class_2960 method_8114() {
        return this.identifier;
    }

    public class_1865<?> method_8119() {
        return NbtCrafting.CAULDRON_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return NbtCrafting.CAULDRON_RECIPE_TYPE;
    }

    @Override
    public Map<String, Object> buildDollarReference(TemporaryCauldronInventory inv) {
        return ImmutableMap.of((Object)"ingredient", (Object)NbtUtil.getTagOrEmpty(inv.method_5438(0)));
    }
}

