/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting.util;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class NumberUtil {
    private static final Class<?>[] NUMBER_TYPES = new Class[]{Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class};
    private static final String[] NUMBER_TYPE_IDENTIFIERS = new String[]{"", "cCb", "s", "i", "l", "f", "d"};
    public static final int CHARACTER = 0;
    public static final int BYTE = 1;
    public static final int SHORT = 2;
    public static final int INTEGER = 3;
    public static final int LONG = 4;
    public static final int FLOAT = 5;
    public static final int DOUBlE = 6;

    public static int getType(String type) {
        for (int i = 0; i < NUMBER_TYPE_IDENTIFIERS.length; ++i) {
            if (!StringUtils.containsAny((CharSequence)NUMBER_TYPE_IDENTIFIERS[i], (CharSequence)type)) continue;
            return i;
        }
        return -1;
    }

    public static int getType(Number number) {
        return ArrayUtils.indexOf((Object[])NUMBER_TYPES, number.getClass());
    }

    public static int findSmallestType(Number a, Number b) {
        int typeA = ArrayUtils.indexOf((Object[])NUMBER_TYPES, a.getClass());
        int typeB = ArrayUtils.indexOf((Object[])NUMBER_TYPES, b.getClass());
        return Math.max(typeA, typeB);
    }

    public static Number denullify(Number number) {
        if (number == null) {
            return (byte)0;
        }
        return number;
    }

    public static Number cast(Number number, int type) {
        if (number == null) {
            return null;
        }
        switch (type) {
            case 0: 
            case 1: {
                return number.byteValue();
            }
            case 2: {
                return number.shortValue();
            }
            case 3: {
                return number.intValue();
            }
            case 4: {
                return number.longValue();
            }
            case 5: {
                return Float.valueOf(number.floatValue());
            }
        }
        return number.doubleValue();
    }

    public static Number sum(Number a, Number b) {
        a = NumberUtil.denullify(a);
        b = NumberUtil.denullify(b);
        switch (NumberUtil.findSmallestType(a, b)) {
            case 0: 
            case 1: {
                return (byte)(a.byteValue() + b.byteValue());
            }
            case 2: {
                return (short)(a.shortValue() + b.shortValue());
            }
            case 3: {
                return a.intValue() + b.intValue();
            }
            case 4: {
                return a.longValue() + b.longValue();
            }
            case 5: {
                return Float.valueOf(a.floatValue() + b.floatValue());
            }
        }
        return a.doubleValue() + b.doubleValue();
    }

    public static Number difference(Number a, Number b) {
        a = NumberUtil.denullify(a);
        b = NumberUtil.denullify(b);
        switch (NumberUtil.findSmallestType(a, b)) {
            case 0: 
            case 1: {
                return (byte)(a.byteValue() - b.byteValue());
            }
            case 2: {
                return (short)(a.shortValue() - b.shortValue());
            }
            case 3: {
                return a.intValue() - b.intValue();
            }
            case 4: {
                return a.longValue() - b.longValue();
            }
            case 5: {
                return Float.valueOf(a.floatValue() - b.floatValue());
            }
        }
        return a.doubleValue() - b.doubleValue();
    }

    public static Number product(Number a, Number b) {
        a = NumberUtil.denullify(a);
        b = NumberUtil.denullify(b);
        switch (NumberUtil.findSmallestType(a, b)) {
            case 0: 
            case 1: {
                return (byte)(a.byteValue() * b.byteValue());
            }
            case 2: {
                return (short)(a.shortValue() * b.shortValue());
            }
            case 3: {
                return a.intValue() * b.intValue();
            }
            case 4: {
                return a.longValue() * b.longValue();
            }
            case 5: {
                return Float.valueOf(a.floatValue() * b.floatValue());
            }
        }
        return a.doubleValue() * b.doubleValue();
    }

    public static Number quotient(Number a, Number b) {
        a = NumberUtil.denullify(a);
        if (b == null || b.doubleValue() == 0.0) {
            return Math.signum(a.doubleValue()) * Double.POSITIVE_INFINITY;
        }
        switch (NumberUtil.findSmallestType(a, b)) {
            case 0: 
            case 1: {
                return (byte)(a.byteValue() / b.byteValue());
            }
            case 2: {
                return (short)(a.shortValue() / b.shortValue());
            }
            case 3: {
                return a.intValue() / b.intValue();
            }
            case 4: {
                return a.longValue() / b.longValue();
            }
            case 5: {
                return Float.valueOf(a.floatValue() / b.floatValue());
            }
        }
        return a.doubleValue() / b.doubleValue();
    }
}

