/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting3.dollar.part.binary;

import de.siphalor.nbtcrafting3.dollar.DollarUtil;
import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.part.value.ConstantDollarPart;
import de.siphalor.nbtcrafting3.dollar.part.value.ValueDollarPart;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;

public class LogicalAndDollarOperator implements DollarPart {
	private final DollarPart left;
	private final DollarPart right;

	private LogicalAndDollarOperator(DollarPart left, DollarPart right) {
		this.left = left;
		this.right = right;
	}

	public static DollarPart of(DollarPart left, DollarPart right) {
		if (left instanceof ConstantDollarPart) {
			if (!DollarUtil.asBoolean(((ConstantDollarPart) left).getConstantValue())) {
				return ValueDollarPart.of(false);
			}
			if (right instanceof ConstantDollarPart) {
				return ValueDollarPart.of(DollarUtil.asBoolean(((ConstantDollarPart) right).getConstantValue()));
			}
		}
		return new LogicalAndDollarOperator(left, right);
	}

	@Override
	public Object evaluate(ReferenceResolver referenceResolver) throws DollarEvaluationException {
		return DollarUtil.asBoolean(left.evaluate(referenceResolver)) && DollarUtil.asBoolean(right.evaluate(referenceResolver));
	}
}
