/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting3.ingredient;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import de.siphalor.nbtcrafting3.util.duck.IItemStack;

public class IngredientMultiStackEntry extends IngredientEntry {

	private final IngredientEntryCondition condition;
	private final IntList itemIds;
	private String tag;

	public IngredientMultiStackEntry(Collection<Integer> items, IngredientEntryCondition condition) {
		super();
		this.condition = condition;
		this.itemIds = new IntArrayList(items);
		this.tag = "";
	}

	@Override
	public boolean matches(class_1799 stack) {
		return itemIds.contains(class_2378.field_11142.method_10206(stack.method_7909())) && condition.matches(stack);
	}

	@Override
	public JsonElement toJson() {
		JsonObject json = new JsonObject();
		json.addProperty("tag", tag);
		condition.addToJson(json);
		return json;
	}

	@Override
	public Collection<class_1799> getPreviewStacks(boolean nbt) {
		class_2487 tag = condition.getPreviewTag();
		Collection<class_1799> stacks = new ArrayList<>(itemIds.size());
		for (Integer id : itemIds) {
			class_1799 stack = new class_1799(class_2378.field_11142.method_10200(id));
			stacks.add(stack);
		}
		if (nbt) {
			for (class_1799 itemStack : stacks) {
				((IItemStack) (Object) itemStack).nbtCrafting$setRawTag(tag);
			}
		}
		return stacks;
	}

	@Override
	public void write(class_2540 buf) {
		buf.method_10804(itemIds.size());
		for (int i = 0; i < itemIds.size(); i++) {
			buf.method_10804(itemIds.getInt(i));
		}
		this.condition.write(buf);
		buf.writeBoolean(remainder != null);
		if (remainder != null)
			buf.method_10793(remainder);
	}

	public static IngredientMultiStackEntry read(class_2540 buf) {
		int length = buf.method_10816();
		ArrayList<Integer> ids = new ArrayList<>(length);
		for (int i = 0; i < length; i++) {
			ids.add(buf.method_10816());
		}
		IngredientMultiStackEntry entry = new IngredientMultiStackEntry(ids, IngredientEntryCondition.read(buf));
		if (buf.readBoolean())
			entry.setRecipeRemainder(buf.method_10819());
		return entry;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

}
