/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting3.mixin;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2371;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

import de.siphalor.nbtcrafting3.api.recipe.NBTCRecipe;
import de.siphalor.nbtcrafting3.dollar.reference.MapBackedReferenceResolver;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;
import de.siphalor.nbtcrafting3.ingredient.IIngredient;

@Mixin(class_1860.class)
public interface MixinRecipe {
	@Shadow
	class_2371<class_1856> getPreviewInputs();

	/**
	 * @reason Returns the recipe remainders. Sadly has to overwrite since this is an interface.
	 * @author Siphalor
	 */
	@Overwrite
	default class_2371<class_1799> getRemainingStacks(class_1263 inventory) {
		final class_2371<class_1799> stackList = class_2371.method_10213(inventory.method_5439(), class_1799.field_8037);
		ReferenceResolver referenceResolver;
		Collection<class_1856> ingredients;
		if (this instanceof NBTCRecipe) {
			ingredients = ((NBTCRecipe<?>) this).getIngredients();
			// noinspection unchecked
			referenceResolver = ((NBTCRecipe<class_1263>) this).getReferenceResolver(inventory);
		} else {
			class_2371<class_1856> ingredientList = getPreviewInputs();
			ingredients = ingredientList;
			Map<String, Object> references = new HashMap<>();
			for (int j = 0; j < ingredientList.size(); j++) {
				for (int i = 0; i < stackList.size(); i++) {
					if (ingredientList.get(j).method_8093(inventory.method_5438(i)))
						references.putIfAbsent("i" + j, inventory.method_5438(i));
				}
			}
			referenceResolver = new MapBackedReferenceResolver(references);
		}
		main:
		for (int i = 0; i < stackList.size(); ++i) {
			class_1799 itemStack = inventory.method_5438(i);
			for (class_1856 ingredient : ingredients) {
				if (ingredient.method_8093(itemStack)) {
					//noinspection ConstantConditions
					class_1799 remainder = ((IIngredient) (Object) ingredient).nbtCrafting3$getRecipeRemainder(itemStack, referenceResolver);
					if (remainder != null) {
						stackList.set(i, remainder);
						continue main;
					}
				}
			}
			if (itemStack.method_7909().method_7857()) {
				stackList.set(i, new class_1799(itemStack.method_7909().method_7858()));
			}
		}
		return stackList;
	}
}
