/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting3.mixin;

import java.util.concurrent.ExecutionException;
import net.minecraft.class_1662;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntList;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting3.util.duck.IItemStack;

@SuppressWarnings("ALL")
@Mixin(class_1662.class)
public abstract class MixinRecipeFinder {
	@Shadow
	public abstract void addItem(final class_1799 stack);

	@Shadow
	@Final
	public Int2IntMap idToAmountMap;

	@Unique
	private static Pair<Integer, class_2487> getStackPair(class_1799 stack) {
		return new Pair<Integer, class_2487>(class_2378.field_11142.method_10206(stack.method_7909()), NbtUtil.getTagOrEmpty(stack));
	}

	@Inject(method = "findRecipe(Lnet/minecraft/recipe/Recipe;Lit/unimi/dsi/fastutil/ints/IntList;I)Z", at = @At("HEAD"))
	public void onFindRecipe(@SuppressWarnings("rawtypes") class_1860 recipe, IntList ints, int int_1, CallbackInfoReturnable<Boolean> ci) {
		NbtCrafting.lastRecipeFinder = (class_1662) (Object) this;
	}

	@Inject(method = "countRecipeCrafts(Lnet/minecraft/recipe/Recipe;ILit/unimi/dsi/fastutil/ints/IntList;)I", at = @At("HEAD"))
	public void onCountCrafts(@SuppressWarnings("rawtypes") class_1860 recipe, int int_1, IntList ints, CallbackInfoReturnable<Integer> ci) {
		NbtCrafting.lastRecipeFinder = (class_1662) (Object) this;
	}

	/**
	 * @reason Fixes nbt items to be excluded from matching sometimes? Shouldn't break anything.
	 * @author Siphalor
	 */
	@Overwrite
	public void addNormalItem(final class_1799 stack) {
		addItem(stack);
	}

	/**
	 * @reason Makes this function nbt dependent
	 * @author Siphalor
	 */
	@Overwrite
	public static int getItemId(class_1799 stack) {
		int id = -1;
		if (stack.method_7960()) {
			id = 0;
		} else {
			Pair<Integer, class_2487> stackPair = getStackPair(stack);
			try {
				id = NbtCrafting.stack2IdMap.get(stackPair);
			} catch (ExecutionException e) {
				e.printStackTrace();
			}
		}
		return id;
	}

	/**
	 * @reason Makes this function nbt dependent
	 * @author Siphalor
	 */
	@Overwrite
	public static class_1799 getStackFromId(final int id) {
		synchronized (NbtCrafting.id2StackMap) {
			if (NbtCrafting.id2StackMap.containsKey(id)) {
				class_1799 result = new class_1799(class_1792.method_7875(NbtCrafting.id2StackMap.get(id).getFirst()));
				((IItemStack) (Object) result).nbtCrafting$setRawTag(NbtCrafting.id2StackMap.get(id).getSecond());
				return result;
			}
		}
		return class_1799.field_8037;
	}
}
