/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting3.mixin.brewing;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_2589;
import net.minecraft.class_2591;
import net.minecraft.class_2624;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.api.RecipeUtil;
import de.siphalor.nbtcrafting3.recipe.BrewingRecipe;

@SuppressWarnings("ConstantConditions")
@Mixin(class_2589.class)
public abstract class MixinBrewingStandBlockEntity extends class_2624 {

	protected MixinBrewingStandBlockEntity(class_2591<?> blockEntityType_1) {
		super(blockEntityType_1);
	}

	@Inject(method = "canCraft", at = @At("HEAD"), cancellable = true)
	private void canCraft(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
		Optional<BrewingRecipe> recipe = field_11863.method_8433().method_8132(NbtCrafting.BREWING_RECIPE_TYPE, (class_2589) (Object) this, field_11863);
		if (recipe.isPresent()) {
			callbackInfoReturnable.setReturnValue(true);
		}
	}

	@Inject(method = "craft", at = @At("HEAD"), cancellable = true)
	private void craft(CallbackInfo callbackInfo) {
		Optional<BrewingRecipe> recipe = field_11863.method_8433().method_8132(NbtCrafting.BREWING_RECIPE_TYPE, (class_2589) (Object) this, field_11863);
		if (recipe.isPresent()) {
			class_2589 inv = (class_2589) (Object) this;
			class_2371<class_1799> remainingStacks = recipe.get().method_8111(inv);
			class_1799[] results = recipe.get().craftAll(inv);

			method_5438(3).method_7934(1);
			for (int i = 0; i < 3; i++) {
				if (results[i] != null) {
					method_5447(i, results[i]);
				}
			}

			RecipeUtil.putRemainders(remainingStacks, inv, field_11863, field_11867);

			field_11863.method_20290(1035, field_11867, 0);

			callbackInfo.cancel();
		}
	}

	@Inject(method = "isValid", at = @At("HEAD"), cancellable = true)
	public void isValidInvStack(int slotId, class_1799 stack, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
		if (slotId < 4 && method_5438(slotId).method_7960()) {
			if (stack.method_7909() != class_1802.field_8183) {
				callbackInfoReturnable.setReturnValue(true);
			}
		}
	}
}
