/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting3.mixin.cauldron;

import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.recipe.cauldron.CauldronRecipe;
import de.siphalor.nbtcrafting3.recipe.cauldron.TemporaryCauldronInventory;

@Mixin(class_2275.class)
public class MixinCauldronBlock {
	@Inject(method = "onUse", at = @At("HEAD"), cancellable = true)
	public void onActivate(class_2680 blockState, class_1937 world, class_2338 blockPos, class_1657 playerEntity, class_1268 hand, class_3965 blockHitResult, CallbackInfoReturnable<class_1269> callbackInfoReturnable) {
		if (!world.method_8608()) {
			TemporaryCauldronInventory inventory = new TemporaryCauldronInventory(playerEntity, hand, world, blockPos);
			Optional<CauldronRecipe> cauldronRecipe = world.method_8433().method_8132(NbtCrafting.CAULDRON_RECIPE_TYPE, inventory, world);
			if (cauldronRecipe.isPresent()) {
				class_2371<class_1799> remainingStacks = cauldronRecipe.get().method_8111(inventory);

				class_1799 itemStack = cauldronRecipe.get().craft(inventory);
				itemStack.method_7982(world, playerEntity, itemStack.method_7947());

				if (!playerEntity.field_7514.method_7394(remainingStacks.get(0))) {
					class_1542 itemEntity = playerEntity.method_7328(remainingStacks.get(0), false);
					if (itemEntity != null) {
						itemEntity.method_6975();
						itemEntity.method_6984(playerEntity.method_5667());
					}
				}

				if (!playerEntity.field_7514.method_7394(itemStack)) {
					class_1542 itemEntity = playerEntity.method_7328(itemStack, false);
					if (itemEntity != null) {
						itemEntity.method_6975();
						itemEntity.method_6984(playerEntity.method_5667());
					}
				}
				callbackInfoReturnable.setReturnValue(class_1269.field_5812);
			}
		}
	}
}
