/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting3.mixin.crafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.api.JsonPreprocessor;
import de.siphalor.nbtcrafting3.api.RecipeUtil;
import de.siphalor.nbtcrafting3.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting3.util.duck.IItemStack;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

@Mixin(class_1869.class)
public abstract class MixinShapedRecipe {
	@Shadow
	@Final
	private class_1799 output;

	@Shadow
	@Final
	private class_2371<class_1856> inputs;

	@Inject(method = "getItemStack", at = @At("HEAD"))
	private static void handlePotions(JsonObject json, CallbackInfoReturnable<class_1799> ci) {
		if (!NbtCrafting.isAdvancedIngredientSerializationEnabled()) {
			return;
		}

		if (json.has("potion")) {
			class_2960 identifier = new class_2960(class_3518.method_15265(json, "potion"));
			if (!class_2378.field_11143.method_17966(identifier).isPresent())
				throw new JsonParseException("The given resulting potion does not exist!");
			JsonObject dataObject;
			if (!json.has("data")) {
				dataObject = new JsonObject();
				json.add("data", dataObject);
			} else
				dataObject = class_3518.method_15296(json, "data");
			dataObject.addProperty("Potion", identifier.toString());
			json.addProperty("item", "minecraft:potion");
		}
	}

	@Inject(
			method = "getItemStack",
			at = @At(value = "INVOKE", target = "com/google/gson/JsonObject.has(Ljava/lang/String;)Z", remap = false)
	)
	private static void deserializeItemStack(JsonObject json, CallbackInfoReturnable<class_1799> ci) {
		if (!NbtCrafting.isAdvancedIngredientSerializationEnabled()) {
			return;
		}

		NbtCrafting.clearLastReadNbt();
		if (json.has("data")) {
			if (class_3518.method_15289(json, "data")) {
				try {
					NbtCrafting.setLastReadNbt(new class_2522(new StringReader(json.get("data").getAsString())).method_10727());
				} catch (CommandSyntaxException e) {
					e.printStackTrace();
				}
			} else {
				NbtCrafting.setLastReadNbt((class_2487) NbtUtil.asTag(JsonPreprocessor.process(class_3518.method_15296(json, "data"))));
			}
			json.remove("data");
		}
	}

	@Inject(
			method = "getItemStack", at = @At("RETURN"), cancellable = true, locals = LocalCapture.CAPTURE_FAILHARD)
	private static void constructDeserializedItemStack(JsonObject json, CallbackInfoReturnable<class_1799> ci, String id, class_1792 item, int amount) {
		if (!NbtCrafting.isAdvancedIngredientSerializationEnabled()) {
			return;
		}

		class_1799 stack = new class_1799(item, amount);
		if (NbtCrafting.hasLastReadNbt()) {
			class_2487 lastReadNbt = NbtCrafting.useLastReadNbt();

			//noinspection ConstantConditions
			((IItemStack) (Object) stack).nbtCrafting$setRawTag(lastReadNbt);
		}
		ci.setReturnValue(stack);
	}

	@Inject(method = "craft", at = @At("HEAD"), cancellable = true)
	public void craft(class_1715 craftingInventory, CallbackInfoReturnable<class_1799> callbackInfoReturnable) {
		class_1799 result = RecipeUtil.getDollarAppliedResult(output, inputs, craftingInventory);
		if (result != null) callbackInfoReturnable.setReturnValue(result);
	}
}
