/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting3.mixin.cutting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

import de.siphalor.nbtcrafting3.NbtCrafting;
import net.minecraft.class_1799;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_3518;
import net.minecraft.class_3972;

@Mixin(class_3972.class_3973.class)
public class MixinCuttingRecipeSerializer {
	private static class_1799 nbtCrafting_resultStack;

	@Redirect(
			method = "read(Lnet/minecraft/util/Identifier;Lcom/google/gson/JsonObject;)Lnet/minecraft/recipe/CuttingRecipe;",
			at = @At(value = "INVOKE", target = "Lnet/minecraft/util/JsonHelper;getString(Lcom/google/gson/JsonObject;Ljava/lang/String;)Ljava/lang/String;")
	)
	public String getResultId(JsonObject jsonObject, String key) {
		nbtCrafting_resultStack = null;
		if (NbtCrafting.isAdvancedIngredientSerializationEnabled() && jsonObject.has(key)) {
			JsonElement jsonElement = jsonObject.get(key);
			if (jsonElement instanceof JsonObject) {
				nbtCrafting_resultStack = class_1869.method_8155((JsonObject) jsonElement);
				return class_2378.field_11142.method_10221(nbtCrafting_resultStack.method_7909()).toString();
			}
		}
		return class_3518.method_15265(jsonObject, key);
	}

	@Redirect(
			method = "read(Lnet/minecraft/util/Identifier;Lcom/google/gson/JsonObject;)Lnet/minecraft/recipe/CuttingRecipe;",
			at = @At(
					value = "NEW",
					target = "net/minecraft/item/ItemStack"
			)
	)
	public class_1799 createStack(class_1935 itemConvertible, int count) {
		if (nbtCrafting_resultStack == null)
			return new class_1799(itemConvertible, count);
		return nbtCrafting_resultStack;
	}
}
