/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting3.recipe.cauldron;

import com.google.gson.JsonObject;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class CauldronRecipeSerializer implements class_1865<CauldronRecipe> {
	@Override
	public CauldronRecipe method_8121(class_2960 identifier, JsonObject jsonObject) {
		return new CauldronRecipe(
				identifier,
				class_1856.method_8102(jsonObject.get("input")),
				class_1869.method_8155(class_3518.method_15296(jsonObject, "result")),
				class_3518.method_15282(jsonObject, "levels", 0)
		);
	}

	@Override
	public CauldronRecipe method_8122(class_2960 identifier, class_2540 packetByteBuf) {
		return CauldronRecipe.from(packetByteBuf);
	}

	@Override
	public void write(class_2540 packetByteBuf, CauldronRecipe cauldronRecipe) {
		cauldronRecipe.write(packetByteBuf);
	}
}
