/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.api.nbt;

import de.siphalor.nbtcrafting3.api.nbt.MergeBehavior;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class MergeContext {
    public static final MergeContext EMPTY = new MergeContext(Collections.emptyList());
    private final Collection<Entry> entries;

    public MergeContext(Collection<Entry> entries) {
        this.entries = entries;
    }

    public static MergeContext parse(String basePath, class_2487 compound) {
        if (compound.method_10573("paths", 10)) {
            if (!basePath.isEmpty()) {
                basePath = basePath + ".";
            }
            class_2487 paths = compound.method_10562("paths");
            ArrayList<Entry> entries = new ArrayList<Entry>(paths.method_10546());
            for (String key : paths.method_10541()) {
                MergeBehavior mergeBehavior = MergeBehavior.valueOf(paths.method_10558(key));
                if (key.startsWith("/") && key.endsWith("/")) {
                    entries.add(new PatternEntry(mergeBehavior, Pattern.compile(Pattern.quote(basePath) + key.substring(1, key.length() - 1))));
                    continue;
                }
                entries.add(new SimpleEntry(mergeBehavior, basePath + key));
            }
            return new MergeContext(entries);
        }
        return EMPTY;
    }

    public MergeBehavior getMergeMode(class_2520 tag, String path) {
        for (Entry entry : this.entries) {
            if (!entry.test(tag, path)) continue;
            return entry.mergeBehavior;
        }
        return MergeBehavior.MERGE;
    }

    public static class PatternEntry
    extends Entry {
        private final Pattern pattern;

        public PatternEntry(MergeBehavior mergeBehavior, Pattern pattern) {
            super(mergeBehavior);
            this.pattern = pattern;
        }

        @Override
        public boolean test(class_2520 tag, String path) {
            return this.pattern.matcher(path).matches();
        }
    }

    public static class SimpleEntry
    extends Entry {
        private final String path;

        public SimpleEntry(MergeBehavior mergeBehavior, String path) {
            super(mergeBehavior);
            this.path = path;
        }

        @Override
        public boolean test(class_2520 tag, String path) {
            return this.path.equals(path);
        }
    }

    public static abstract class Entry {
        private final MergeBehavior mergeBehavior;

        public Entry(MergeBehavior mergeBehavior) {
            this.mergeBehavior = mergeBehavior;
        }

        public abstract boolean test(class_2520 var1, String var2);
    }
}

