/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar;

import de.siphalor.nbtcrafting3.dollar.DollarLambda;
import de.siphalor.nbtcrafting3.dollar.antlr.DollarScriptParser;
import de.siphalor.nbtcrafting3.dollar.antlr.DollarScriptParserBaseVisitor;
import de.siphalor.nbtcrafting3.dollar.exception.DollarDeserializationException;
import de.siphalor.nbtcrafting3.dollar.function.DollarFunction;
import de.siphalor.nbtcrafting3.dollar.function.DollarFunctions;
import de.siphalor.nbtcrafting3.dollar.part.DollarBinding;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.part.binary.AssignmentDollarPart;
import de.siphalor.nbtcrafting3.dollar.part.binary.CastDollarOperator;
import de.siphalor.nbtcrafting3.dollar.part.binary.ChildDollarOperator;
import de.siphalor.nbtcrafting3.dollar.part.binary.ComparisonDollarOperator;
import de.siphalor.nbtcrafting3.dollar.part.binary.LogicalAndDollarOperator;
import de.siphalor.nbtcrafting3.dollar.part.binary.LogicalOrDollarOperator;
import de.siphalor.nbtcrafting3.dollar.part.binary.NumericBinaryDollarOperator;
import de.siphalor.nbtcrafting3.dollar.part.binary.ProductDollarOperator;
import de.siphalor.nbtcrafting3.dollar.part.binary.SumDollarOperator;
import de.siphalor.nbtcrafting3.dollar.part.special.DollarStatementList;
import de.siphalor.nbtcrafting3.dollar.part.special.FunctionCallDollarPart;
import de.siphalor.nbtcrafting3.dollar.part.ternary.ConditionDollarOperator;
import de.siphalor.nbtcrafting3.dollar.part.unary.NegationDollarOperator;
import de.siphalor.nbtcrafting3.dollar.part.unary.NotDollarOperator;
import de.siphalor.nbtcrafting3.dollar.part.value.ListConstructDollarPart;
import de.siphalor.nbtcrafting3.dollar.part.value.ObjectConstructDollarPart;
import de.siphalor.nbtcrafting3.dollar.part.value.ReferenceDollarPart;
import de.siphalor.nbtcrafting3.dollar.part.value.ValueDollarPart;
import de.siphalor.nbtcrafting3.util.NumberUtil;
import java.util.List;
import net.minecraft.class_3545;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class DollarScriptVisitor
extends DollarScriptParserBaseVisitor<DollarPart> {
    @Override
    public DollarPart visitNumber(DollarScriptParser.NumberContext ctx) {
        TerminalNode node = ctx.INTEGER_LITERAL();
        if (node != null) {
            return ValueDollarPart.of(NumberUtil.toSmallestInteger(Long.parseLong(node.getText())));
        }
        node = ctx.FLOAT_LITERAL();
        return ValueDollarPart.of(Double.parseDouble(node.getText()));
    }

    @Override
    public DollarPart visitStringLiteral(DollarScriptParser.StringLiteralContext ctx) {
        String text = ctx.getText();
        return ValueDollarPart.of(text.substring(1, text.length() - 1));
    }

    @Override
    public DollarPart visitIdentifier(DollarScriptParser.IdentifierContext ctx) {
        return ReferenceDollarPart.of(ctx.getText());
    }

    @Override
    public DollarPart visitNamedConstant(DollarScriptParser.NamedConstantContext ctx) {
        switch (ctx.start.getType()) {
            case 34: {
                return ValueDollarPart.of(true);
            }
            case 35: {
                return ValueDollarPart.of(false);
            }
            case 36: {
                return ValueDollarPart.of(null);
            }
        }
        throw new RuntimeException("Unknown named constant: " + ctx.start.getText());
    }

    @Override
    public DollarPart visitNesting(DollarScriptParser.NestingContext ctx) {
        return (DollarPart)this.visit((ParseTree)ctx.expr());
    }

    @Override
    public DollarPart visitListConstruct(DollarScriptParser.ListConstructContext ctx) {
        try {
            return ListConstructDollarPart.of((DollarPart[])ctx.expr().stream().map(arg_0 -> ((DollarScriptVisitor)this).visit(arg_0)).toArray(DollarPart[]::new));
        }
        catch (DollarDeserializationException e) {
            throw new RuntimeException("Failed to read list construct at " + ctx.getStart().getLine() + ": " + ctx.getStart().getCharPositionInLine());
        }
    }

    @Override
    public DollarPart visitObjectConstruct(DollarScriptParser.ObjectConstructContext ctx) {
        try {
            return ObjectConstructDollarPart.of((class_3545[])ctx.objectConstructProperty().stream().map(prop -> new class_3545((Object)prop.identifier().getText(), (Object)((DollarPart)this.visit((ParseTree)prop.expr())))).toArray(class_3545[]::new));
        }
        catch (DollarDeserializationException e) {
            throw new RuntimeException("Failed to read object construct at " + ctx.getStart().getLine() + ": " + ctx.getStart().getCharPositionInLine());
        }
    }

    @Override
    public DollarPart visitLambda(DollarScriptParser.LambdaContext ctx) {
        List<DollarScriptParser.IdentifierContext> identifierContexts = ctx.identifier();
        String[] parameters = new String[identifierContexts.size()];
        for (int i = 0; i < identifierContexts.size(); ++i) {
            parameters[i] = identifierContexts.get(i).getText();
        }
        if (ctx.inline != null) {
            return ValueDollarPart.of(new DollarLambda(parameters, this.visitExpr(ctx.inline)));
        }
        return ValueDollarPart.of(new DollarLambda(parameters, this.visitStatementList(ctx.body)));
    }

    @Override
    public DollarPart visitFunctionCall(DollarScriptParser.FunctionCallContext ctx) {
        String identifier = ctx.identifier().getText();
        DollarFunction dollarFunction = DollarFunctions.get(identifier);
        if (dollarFunction != null) {
            try {
                return FunctionCallDollarPart.of(dollarFunction, (DollarPart[])ctx.expr().stream().map(arg_0 -> ((DollarScriptVisitor)this).visit(arg_0)).toArray(DollarPart[]::new));
            }
            catch (DollarDeserializationException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Unknown function \"" + identifier + "\" at " + ctx.getStart().getLine() + ":" + ctx.getStart().getCharPositionInLine());
    }

    @Override
    public DollarBinding visitLexpr(DollarScriptParser.LexprContext ctx) {
        if (ctx.op == null) {
            return new ReferenceDollarPart(ctx.identifier().getText());
        }
        DollarBinding left = this.visitLexpr(ctx.lexpr());
        switch (ctx.op.getType()) {
            case 13: {
                return new ChildDollarOperator(left, ValueDollarPart.of(ctx.identifier().getText()));
            }
            case 6: {
                DollarScriptParser.ExprContext keyExpr = ctx.expr();
                if (keyExpr == null) {
                    return new ChildDollarOperator(left, null);
                }
                return new ChildDollarOperator(left, this.visitExpr(keyExpr));
            }
        }
        throw new RuntimeException("Unsupported operator: " + ctx.op.getText());
    }

    @Override
    public DollarPart visitAssignmentExpr(DollarScriptParser.AssignmentExprContext ctx) {
        return AssignmentDollarPart.of(this.visitLexpr(ctx.lexpr()), this.visitExpr(ctx.expr()));
    }

    @Override
    public DollarPart visitExpr(DollarScriptParser.ExprContext ctx) {
        if (ctx.op == null) {
            if (ctx.getChildCount() == 0) {
                return (DollarPart)this.defaultResult();
            }
            return (DollarPart)this.visit(ctx.getChild(0));
        }
        try {
            List<DollarScriptParser.ExprContext> expressions = ctx.expr();
            switch (ctx.op.getType()) {
                case 13: {
                    return ChildDollarOperator.of(this.visitExpr(expressions.get(0)), ValueDollarPart.of(ctx.identifier().getText()));
                }
                case 28: {
                    return ChildDollarOperator.of(this.visitExpr(expressions.get(0)), ValueDollarPart.of(ctx.identifier().getText()), true);
                }
                case 6: {
                    return ChildDollarOperator.of(this.visitExpr(expressions.get(0)), this.visitExpr(expressions.get(1)));
                }
                case 2: {
                    return CastDollarOperator.of(this.visitExpr(expressions.get(0)), ctx.HASH_CAST().getText().charAt(1));
                }
                case 19: {
                    return NotDollarOperator.of(this.visitExpr(expressions.get(0)));
                }
                case 15: {
                    if (expressions.size() == 1) {
                        return NegationDollarOperator.of(this.visitExpr(expressions.get(0)));
                    }
                    return NumericBinaryDollarOperator.differenceOf(this.visitExpr(expressions.get(0)), this.visitExpr(expressions.get(1)));
                }
                case 14: {
                    if (expressions.size() == 1) {
                        return CastDollarOperator.of(this.visitExpr(expressions.get(0)), 110);
                    }
                    return SumDollarOperator.of(this.visitExpr(expressions.get(0)), this.visitExpr(expressions.get(1)));
                }
                case 16: {
                    return NumericBinaryDollarOperator.differenceOf(this.visitExpr(expressions.get(0)), this.visitExpr(expressions.get(1)));
                }
                case 17: {
                    return ProductDollarOperator.of(this.visitExpr(expressions.get(0)), this.visitExpr(expressions.get(1)));
                }
                case 24: {
                    return ComparisonDollarOperator.of(ComparisonDollarOperator.Type.EQUAL, this.visitExpr(expressions.get(0)), this.visitExpr(expressions.get(1)));
                }
                case 25: {
                    return ComparisonDollarOperator.of(ComparisonDollarOperator.Type.NOT_EQUAL, this.visitExpr(expressions.get(0)), this.visitExpr(expressions.get(1)));
                }
                case 20: {
                    return ComparisonDollarOperator.of(ComparisonDollarOperator.Type.LESS, this.visitExpr(expressions.get(0)), this.visitExpr(expressions.get(1)));
                }
                case 22: {
                    return ComparisonDollarOperator.of(ComparisonDollarOperator.Type.LESS_OR_EQUAL, this.visitExpr(expressions.get(0)), this.visitExpr(expressions.get(1)));
                }
                case 21: {
                    return ComparisonDollarOperator.of(ComparisonDollarOperator.Type.GREATER, this.visitExpr(expressions.get(0)), this.visitExpr(expressions.get(1)));
                }
                case 23: {
                    return ComparisonDollarOperator.of(ComparisonDollarOperator.Type.GREATER_OR_EQUAL, this.visitExpr(expressions.get(0)), this.visitExpr(expressions.get(1)));
                }
                case 27: {
                    return LogicalAndDollarOperator.of(this.visitExpr(expressions.get(0)), this.visitExpr(expressions.get(1)));
                }
                case 26: {
                    return LogicalOrDollarOperator.of(this.visitExpr(expressions.get(0)), this.visitExpr(expressions.get(1)));
                }
                case 10: {
                    return ConditionDollarOperator.of(this.visitExpr(expressions.get(0)), this.visitExpr(expressions.get(1)), this.visitExpr(expressions.get(2)));
                }
            }
        }
        catch (DollarDeserializationException e) {
            throw new RuntimeException("Failed to read dollar expression at " + ctx.op.getCharPositionInLine() + ":" + ctx.op.getLine(), e);
        }
        return null;
    }

    @Override
    public DollarPart visitStatementList(DollarScriptParser.StatementListContext ctx) {
        List<DollarScriptParser.StatementContext> statementContexts = ctx.statement();
        DollarPart[] statements = new DollarPart[statementContexts.size()];
        for (int i = 0; i < statementContexts.size(); ++i) {
            statements[i] = (DollarPart)this.visitStatement(statementContexts.get(i));
        }
        return DollarStatementList.of(statements);
    }

    @Override
    public DollarPart visitScript(DollarScriptParser.ScriptContext ctx) {
        return this.visitStatementList(ctx.statementList());
    }
}

