/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar.part.binary;

import de.siphalor.nbtcrafting3.dollar.DollarUtil;
import de.siphalor.nbtcrafting3.dollar.exception.DollarDeserializationException;
import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.part.binary.BinaryDollarOperator;
import de.siphalor.nbtcrafting3.util.NumberUtil;

public class ComparisonDollarOperator
extends BinaryDollarOperator {
    private final Type type;

    private ComparisonDollarOperator(Type type, DollarPart first, DollarPart second) {
        super(first, second);
        this.type = type;
    }

    @Override
    public Object apply(Object first, Object second) throws DollarEvaluationException {
        if ((first instanceof Number || first == null) && (second instanceof Number || second == null)) {
            Number firstNumber = NumberUtil.denullify((Number)first);
            Number secondNumber = NumberUtil.denullify((Number)second);
            return this.type.matches(Double.compare(firstNumber.doubleValue(), secondNumber.doubleValue()));
        }
        if (first instanceof String && second instanceof String) {
            return this.type.matches(first.toString().compareTo(second.toString()));
        }
        if (this.type == Type.EQUAL) {
            return DollarUtil.equals(first, second);
        }
        if (this.type == Type.NOT_EQUAL) {
            return !DollarUtil.equals(first, second);
        }
        throw new DollarEvaluationException("Cannot compare " + first + " with " + second + " with operator " + this.type.operator());
    }

    public static DollarPart of(Type type, DollarPart first, DollarPart second) throws DollarDeserializationException {
        return ComparisonDollarOperator.shortCircuitConstant(new ComparisonDollarOperator(type, first, second));
    }

    public static enum Type {
        EQUAL,
        NOT_EQUAL,
        LESS,
        LESS_OR_EQUAL,
        GREATER,
        GREATER_OR_EQUAL;


        public static Type fromString(String string) {
            switch (string) {
                case "==": {
                    return EQUAL;
                }
                case "!=": {
                    return NOT_EQUAL;
                }
                case "<": {
                    return LESS;
                }
                case "<=": {
                    return LESS_OR_EQUAL;
                }
                case ">": {
                    return GREATER;
                }
                case ">=": {
                    return GREATER_OR_EQUAL;
                }
            }
            throw new IllegalArgumentException("Unknown comparison operator: " + string);
        }

        public String operator() {
            switch (this) {
                case EQUAL: {
                    return "==";
                }
                case NOT_EQUAL: {
                    return "!=";
                }
                case LESS: {
                    return "<";
                }
                case LESS_OR_EQUAL: {
                    return "<=";
                }
                case GREATER: {
                    return ">";
                }
                case GREATER_OR_EQUAL: {
                    return ">=";
                }
            }
            throw new IllegalArgumentException("Unknown comparison type: " + this.name());
        }

        private boolean matches(int comparisonResult) {
            switch (this) {
                case EQUAL: {
                    return comparisonResult == 0;
                }
                case NOT_EQUAL: {
                    return comparisonResult != 0;
                }
                case LESS: {
                    return comparisonResult < 0;
                }
                case LESS_OR_EQUAL: {
                    return comparisonResult <= 0;
                }
                case GREATER: {
                    return comparisonResult > 0;
                }
                case GREATER_OR_EQUAL: {
                    return comparisonResult >= 0;
                }
            }
            throw new IllegalStateException("Unknown comparison type: " + this.name());
        }
    }
}

