/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar.part.binary;

import de.siphalor.nbtcrafting3.dollar.DollarUtil;
import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.part.value.ConstantDollarPart;
import de.siphalor.nbtcrafting3.dollar.part.value.ValueDollarPart;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;

public class LogicalAndDollarOperator
implements DollarPart {
    private final DollarPart left;
    private final DollarPart right;

    private LogicalAndDollarOperator(DollarPart left, DollarPart right) {
        this.left = left;
        this.right = right;
    }

    public static DollarPart of(DollarPart left, DollarPart right) {
        if (left instanceof ConstantDollarPart) {
            if (!DollarUtil.asBoolean(((ConstantDollarPart)left).getConstantValue())) {
                return ValueDollarPart.of(false);
            }
            if (right instanceof ConstantDollarPart) {
                return ValueDollarPart.of(DollarUtil.asBoolean(((ConstantDollarPart)right).getConstantValue()));
            }
        }
        return new LogicalAndDollarOperator(left, right);
    }

    @Override
    public Object evaluate(ReferenceResolver referenceResolver) throws DollarEvaluationException {
        return DollarUtil.asBoolean(this.left.evaluate(referenceResolver)) && DollarUtil.asBoolean(this.right.evaluate(referenceResolver));
    }
}

