/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar.part.value;

import de.siphalor.nbtcrafting3.dollar.exception.DollarDeserializationException;
import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.part.value.ConstantDollarPart;
import de.siphalor.nbtcrafting3.dollar.part.value.ValueDollarPart;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;
import java.util.ArrayList;

public class ListConstructDollarPart
implements DollarPart {
    private final DollarPart[] parts;

    private ListConstructDollarPart(DollarPart[] parts) {
        this.parts = parts;
    }

    public static DollarPart of(DollarPart ... parts) throws DollarDeserializationException {
        ListConstructDollarPart instance = new ListConstructDollarPart(parts);
        for (DollarPart part : parts) {
            if (part instanceof ConstantDollarPart) continue;
            return instance;
        }
        try {
            return ValueDollarPart.of(instance.evaluate(null));
        }
        catch (DollarEvaluationException e) {
            throw new DollarDeserializationException("Failed to short-circuit dollar list construct", e);
        }
    }

    @Override
    public Object evaluate(ReferenceResolver referenceResolver) throws DollarEvaluationException {
        ArrayList<Object> result = new ArrayList<Object>(this.parts.length);
        for (DollarPart part : this.parts) {
            result.add(part.evaluate(referenceResolver));
        }
        return result;
    }
}

