/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting3.dollar.DollarExtractor;
import de.siphalor.nbtcrafting3.dollar.DollarUtil;
import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.exception.UnresolvedDollarReferenceException;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import net.minecraft.class_3545;

public class IngredientEntryCondition {
    public static final IngredientEntryCondition EMPTY = new IngredientEntryCondition(NbtUtil.EMPTY_COMPOUND, NbtUtil.EMPTY_COMPOUND);
    public class_2487 requiredElements;
    public class_2487 deniedElements;
    public List<class_3545<String, DollarPart>> dollarPredicates;

    protected IngredientEntryCondition() {
        this.requiredElements = NbtUtil.EMPTY_COMPOUND;
        this.deniedElements = NbtUtil.EMPTY_COMPOUND;
        this.dollarPredicates = null;
    }

    public IngredientEntryCondition(class_2487 requiredElements, class_2487 deniedElements) {
        this.requiredElements = requiredElements;
        this.deniedElements = deniedElements;
    }

    public boolean matches(class_1799 stack) {
        if (!stack.method_7985()) {
            return this.requiredElements.isEmpty();
        }
        class_2487 tag = stack.method_7969();
        if (!this.deniedElements.isEmpty() && NbtUtil.compoundsOverlap(tag, this.deniedElements)) {
            return false;
        }
        if (!this.requiredElements.isEmpty() && !NbtUtil.isCompoundContained(this.requiredElements, tag)) {
            return false;
        }
        if (this.dollarPredicates != null && !this.dollarPredicates.isEmpty()) {
            for (class_3545<String, DollarPart> predicate : this.dollarPredicates) {
                try {
                    if (DollarUtil.asBoolean(((DollarPart)predicate.method_15441()).evaluate(ref -> {
                        if ("$".equals(ref)) {
                            return tag;
                        }
                        throw new UnresolvedDollarReferenceException(ref);
                    }))) continue;
                    return false;
                }
                catch (DollarEvaluationException e) {
                    NbtCrafting.logWarn("Failed to evaluate dollar predicate (" + (String)predicate.method_15442() + "): " + e.getMessage());
                }
            }
        }
        return true;
    }

    public void addToJson(JsonObject json) {
        if (this.requiredElements.method_10546() > 0) {
            json.add("require", NbtUtil.toJson((class_2520)this.requiredElements));
        }
        if (this.deniedElements.method_10546() > 0) {
            json.add("deny", NbtUtil.toJson((class_2520)this.deniedElements));
        }
        if (this.dollarPredicates != null && !this.dollarPredicates.isEmpty()) {
            JsonArray array = new JsonArray();
            for (class_3545<String, DollarPart> condition : this.dollarPredicates) {
                array.add((String)condition.method_15442());
            }
            json.add("conditions", (JsonElement)array);
        }
    }

    public class_2487 getPreviewTag() {
        return this.requiredElements;
    }

    public static IngredientEntryCondition fromJson(JsonObject json) {
        IngredientEntryCondition condition = new IngredientEntryCondition();
        boolean flatObject = true;
        if (json.has("require")) {
            if (!json.get("require").isJsonObject()) {
                throw new JsonParseException("data.require must be an object");
            }
            condition.requiredElements = (class_2487)NbtUtil.asTag((JsonElement)json.getAsJsonObject("require"));
            flatObject = false;
        }
        if (json.has("deny")) {
            if (!json.get("deny").isJsonObject()) {
                throw new JsonParseException("data.deny must be an object");
            }
            condition.deniedElements = (class_2487)NbtUtil.asTag((JsonElement)json.getAsJsonObject("deny"));
            flatObject = false;
        }
        if (json.has("conditions")) {
            if (!json.get("conditions").isJsonArray()) {
                throw new JsonParseException("data.conditions must be an array");
            }
            JsonArray array = json.getAsJsonArray("conditions");
            ArrayList<class_3545<String, DollarPart>> predicates = new ArrayList<class_3545<String, DollarPart>>(array.size());
            for (JsonElement jsonElement : array) {
                if (!class_3518.method_15286((JsonElement)jsonElement)) {
                    throw new JsonParseException("data.conditions must be an array of strings");
                }
                predicates.add((class_3545<String, DollarPart>)new class_3545((Object)jsonElement.getAsString(), (Object)DollarExtractor.parse(jsonElement.getAsString())));
            }
            condition.dollarPredicates = predicates;
            flatObject = false;
        }
        if (flatObject) {
            condition.requiredElements = (class_2487)NbtUtil.asTag((JsonElement)json);
        }
        return condition;
    }

    public void write(class_2540 buf) {
        buf.method_10794(this.requiredElements);
        buf.method_10794(this.deniedElements);
    }

    public static IngredientEntryCondition read(class_2540 buf) {
        return new IngredientEntryCondition(buf.method_10798(), buf.method_10798());
    }
}

