/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.util;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.siphalor.nbtcrafting3.util.NumberUtil;

public class BetterJsonOps
extends JsonOps {
    public static final BetterJsonOps INSTANCE = new BetterJsonOps(false);

    protected BetterJsonOps(boolean compressed) {
        super(compressed);
    }

    public <U> U convertTo(DynamicOps<U> outOps, JsonElement input) {
        if (input.isJsonPrimitive() && input.getAsJsonPrimitive().isNumber()) {
            Number val = input.getAsNumber();
            int type = NumberUtil.getType(val);
            switch (type) {
                case 0: 
                case 1: {
                    return (U)outOps.createByte(val.byteValue());
                }
                case 2: {
                    return (U)outOps.createShort(val.shortValue());
                }
                case 3: {
                    return (U)outOps.createInt(val.intValue());
                }
                case 4: {
                    return (U)outOps.createLong(val.longValue());
                }
                case 5: {
                    return (U)outOps.createFloat(val.floatValue());
                }
                case 6: {
                    return (U)outOps.createDouble(val.doubleValue());
                }
            }
        }
        return (U)super.convertTo(outOps, input);
    }
}

