/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.util.Pair;
import de.siphalor.nbtcrafting3.advancement.StatChangedCriterion;
import de.siphalor.nbtcrafting3.api.RecipeTypeHelper;
import de.siphalor.nbtcrafting3.ingredient.IIngredient;
import de.siphalor.nbtcrafting3.mixin.advancement.MixinCriterions;
import de.siphalor.nbtcrafting3.recipe.AnvilRecipe;
import de.siphalor.nbtcrafting3.recipe.BrewingRecipe;
import de.siphalor.nbtcrafting3.recipe.IngredientRecipe;
import de.siphalor.nbtcrafting3.recipe.WrappedRecipeSerializer;
import de.siphalor.nbtcrafting3.recipe.cauldron.CauldronRecipe;
import de.siphalor.nbtcrafting3.recipe.cauldron.CauldronRecipeSerializer;
import de.siphalor.nbtcrafting3.util.duck.IServerPlayerEntity;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.inventory.Inventory;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.recipe.Ingredient;
import net.minecraft.recipe.Recipe;
import net.minecraft.recipe.RecipeManager;
import net.minecraft.recipe.RecipeMatcher;
import net.minecraft.recipe.RecipeSerializer;
import net.minecraft.recipe.RecipeType;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.util.Identifier;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class NbtCrafting
implements ModInitializer {
    public static final String MOD_ID = "nbtcrafting3";
    public static final String MOD_NAME = "Nbt Crafting v3";
    private static final String LOG_PREFIX = "[Nbt Crafting v3] ";
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Identifier PRESENCE_CHANNEL = new Identifier("nbtcrafting3", "present");
    public static final Identifier UPDATE_ANVIL_TEXT_S2C_PACKET_ID = new Identifier("nbtcrafting3", "update_anvil_text");
    public static final Identifier UPDATE_ADVANCED_RECIPES_PACKET_ID = new Identifier("nbtcrafting3", "update_advanced_recipes");
    public static final RecipeType<AnvilRecipe> ANVIL_RECIPE_TYPE = NbtCrafting.registerRecipeType("anvil");
    public static final RecipeSerializer<AnvilRecipe> ANVIL_RECIPE_SERIALIZER = NbtCrafting.registerRecipeSerializer("anvil", AnvilRecipe.SERIALIZER);
    public static final RecipeType<BrewingRecipe> BREWING_RECIPE_TYPE = NbtCrafting.registerRecipeType("brewing");
    public static final RecipeSerializer<BrewingRecipe> BREWING_RECIPE_SERIALIZER = NbtCrafting.registerRecipeSerializer("brewing", BrewingRecipe.SERIALIZER);
    public static final RecipeType<CauldronRecipe> CAULDRON_RECIPE_TYPE = NbtCrafting.registerRecipeType("cauldron");
    public static final CauldronRecipeSerializer CAULDRON_RECIPE_SERIALIZER = NbtCrafting.registerRecipeSerializer("cauldron", new CauldronRecipeSerializer());
    public static final RecipeType<IngredientRecipe<Inventory>> SMITHING_RECIPE_TYPE = NbtCrafting.registerRecipeType("smithing");
    public static final RecipeSerializer<IngredientRecipe<Inventory>> SMITHING_RECIPE_SERIALIZER = NbtCrafting.registerRecipeSerializer("smithing", new IngredientRecipe.Serializer<IngredientRecipe>((id, base, ingredient, result, serializer) -> new IngredientRecipe<Inventory>(id, base, ingredient, result, SMITHING_RECIPE_TYPE, serializer)));
    public static final RecipeSerializer<Recipe<?>> DATA_RECIPE_SERIALIZER = NbtCrafting.registerRecipeSerializer("data", new WrappedRecipeSerializer());
    public static final StatChangedCriterion STAT_CHANGED_CRITERION = MixinCriterions.registerCriterion(new StatChangedCriterion());
    private static boolean lastReadNbtPresent = false;
    private static NbtCompound lastReadNbt;
    public static RecipeMatcher lastRecipeFinder;
    public static ThreadLocal<ServerPlayerEntity> lastServerPlayerEntity;
    public static ThreadLocal<Boolean> advancedIngredientSerializationEnabled;
    private static final IntSet hasModClientConnectionHashes;
    private static int currentStackId;
    public static final Int2ObjectMap<Pair<Integer, NbtCompound>> id2StackMap;
    public static final LoadingCache<Pair<Integer, NbtCompound>, Integer> stack2IdMap;

    public static void logInfo(String message) {
        LOGGER.info(LOG_PREFIX + message);
    }

    public static void logWarn(String message) {
        LOGGER.warn(LOG_PREFIX + message);
    }

    public static void logError(String message) {
        LOGGER.error(LOG_PREFIX + message);
    }

    public static boolean hasLastReadNbt() {
        return lastReadNbtPresent;
    }

    public static void clearLastReadNbt() {
        lastReadNbt = null;
        lastReadNbtPresent = false;
    }

    public static void setLastReadNbt(NbtCompound nbt) {
        lastReadNbt = nbt;
        lastReadNbtPresent = true;
    }

    public static NbtCompound useLastReadNbt() {
        NbtCompound result = null;
        if (lastReadNbt != null) {
            result = lastReadNbt.copy();
            lastReadNbt = null;
        }
        lastReadNbtPresent = false;
        return result;
    }

    public void onInitialize() {
        ServerLoginConnectionEvents.QUERY_START.register((handler, server, sender, synchronizer) -> sender.sendPacket(PRESENCE_CHANNEL, new PacketByteBuf(Unpooled.buffer())));
        ServerLoginConnectionEvents.DISCONNECT.register((handler, server) -> hasModClientConnectionHashes.remove(handler.getConnection().hashCode()));
        ServerLoginNetworking.registerGlobalReceiver((Identifier)PRESENCE_CHANNEL, (server, handler, understood, buf, synchronizer, responseSender) -> {
            if (understood) {
                hasModClientConnectionHashes.add(handler.getConnection().hashCode());
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (hasModClientConnectionHashes.contains(handler.getConnection().hashCode())) {
                ((IServerPlayerEntity)handler.player).nbtCrafting3$setClientModPresent(true);
                hasModClientConnectionHashes.remove(handler.getConnection().hashCode());
            }
        });
    }

    public static boolean hasClientMod(ServerPlayerEntity playerEntity) {
        if (playerEntity instanceof IServerPlayerEntity) {
            return ((IServerPlayerEntity)playerEntity).nbtCrafting3$hasClientMod();
        }
        return false;
    }

    public static <T extends Recipe<?>> RecipeType<T> registerRecipeType(final String name) {
        Identifier recipeTypeId = new Identifier(MOD_ID, name);
        RecipeTypeHelper.addToSyncBlacklist(recipeTypeId);
        return (RecipeType)Registry.register((Registry)Registry.RECIPE_TYPE, (Identifier)recipeTypeId, (Object)new RecipeType<T>(){

            public String toString() {
                return "nbtcrafting3:" + name;
            }
        });
    }

    public static <S extends RecipeSerializer<T>, T extends Recipe<?>> S registerRecipeSerializer(String name, S recipeSerializer) {
        Identifier serializerId = new Identifier(MOD_ID, name);
        RecipeTypeHelper.addToSyncBlacklist(serializerId);
        return (S)((RecipeSerializer)Registry.register((Registry)Registry.RECIPE_SERIALIZER, (Identifier)serializerId, recipeSerializer));
    }

    public static List<PacketByteBuf> createAdvancedRecipeSyncPackets(RecipeManager recipeManager) {
        advancedIngredientSerializationEnabled.set(true);
        List recipes = recipeManager.values().stream().filter(recipe -> {
            for (Ingredient ingredient : recipe.getIngredients()) {
                if (!((IIngredient)ingredient).nbtCrafting3$isAdvanced()) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        ArrayList<PacketByteBuf> packets = new ArrayList<PacketByteBuf>();
        PacketByteBuf buf = new PacketByteBuf(Unpooled.buffer());
        buf.writeVarInt(0);
        for (Recipe recipe2 : recipes) {
            RecipeSerializer serializer = recipe2.getSerializer();
            buf.writeIdentifier(Registry.RECIPE_SERIALIZER.getId((Object)serializer));
            buf.writeIdentifier(recipe2.getId());
            serializer.write(buf, recipe2);
            if (buf.readableBytes() <= 1900000) continue;
            packets.add(buf);
            buf = new PacketByteBuf(Unpooled.buffer());
            buf.writeVarInt(0);
        }
        advancedIngredientSerializationEnabled.set(false);
        return packets;
    }

    public static boolean isAdvancedIngredientSerializationEnabled() {
        return advancedIngredientSerializationEnabled.get() != null && advancedIngredientSerializationEnabled.get() != false;
    }

    static {
        lastServerPlayerEntity = new ThreadLocal();
        advancedIngredientSerializationEnabled = new ThreadLocal();
        hasModClientConnectionHashes = IntSets.synchronize((IntSet)new IntAVLTreeSet());
        currentStackId = 1;
        id2StackMap = new Int2ObjectAVLTreeMap();
        stack2IdMap = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener(notification -> {
            Int2ObjectMap<Pair<Integer, NbtCompound>> int2ObjectMap = id2StackMap;
            synchronized (int2ObjectMap) {
                id2StackMap.remove(((Integer)notification.getValue()).intValue());
            }
        }).build((CacheLoader)new CacheLoader<Pair<Integer, NbtCompound>, Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer load(@NotNull Pair<Integer, NbtCompound> key) {
                Int2ObjectMap<Pair<Integer, NbtCompound>> int2ObjectMap = id2StackMap;
                synchronized (int2ObjectMap) {
                    while (id2StackMap.putIfAbsent(currentStackId, key) != null) {
                        ++currentStackId;
                    }
                    int n = currentStackId++;
                    return n;
                }
            }
        });
    }
}

