/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.advancement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.advancement.criterion.AbstractCriterion;
import net.minecraft.advancement.criterion.AbstractCriterionConditions;
import net.minecraft.predicate.NumberRange;
import net.minecraft.predicate.entity.AdvancementEntityPredicateDeserializer;
import net.minecraft.predicate.entity.EntityPredicate;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.stat.Stat;
import net.minecraft.stat.StatType;
import net.minecraft.util.Identifier;
import net.minecraft.util.JsonHelper;
import net.minecraft.util.registry.Registry;

public class StatChangedCriterion
extends AbstractCriterion<Conditions<?>> {
    private static final Identifier ID = new Identifier("nbtcrafting3", "stat_changed");

    public Identifier getId() {
        return ID;
    }

    public <T> void trigger(ServerPlayerEntity player, Stat<T> stat, int value) {
        StatType statType = stat.getType();
        Object object = stat.getValue();
        this.test(player, conditions -> conditions.match(statType, object, value));
    }

    protected Conditions<?> conditionsFromJson(JsonObject obj, EntityPredicate.Extended playerPredicate, AdvancementEntityPredicateDeserializer predicateDeserializer) {
        Identifier statId = new Identifier(JsonHelper.getString((JsonObject)obj, (String)"stat"));
        StatType statType = (StatType)Registry.STAT_TYPE.getOrEmpty(statId).orElseThrow(() -> new JsonSyntaxException("Unknown stat: " + statId));
        Identifier id = new Identifier(JsonHelper.getString((JsonObject)obj, (String)"id"));
        Object object = statType.getRegistry().get(id);
        return new Conditions<Object>(statType, object, NumberRange.IntRange.fromJson((JsonElement)obj.get("range")), playerPredicate);
    }

    static class Conditions<T>
    extends AbstractCriterionConditions {
        private final StatType<T> statType;
        private final T object;
        private final NumberRange.IntRange intRange;

        public Conditions(StatType<T> statType, T object, NumberRange.IntRange intRange, EntityPredicate.Extended playerPredicate) {
            super(ID, playerPredicate);
            this.statType = statType;
            this.object = object;
            this.intRange = intRange;
        }

        public boolean match(StatType<?> statType, Object object, int value) {
            if (statType == this.statType && object == this.object) {
                return this.intRange.test(value);
            }
            return false;
        }
    }
}

