/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.api;

import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.dollar.Dollar;
import de.siphalor.nbtcrafting3.dollar.DollarExtractor;
import de.siphalor.nbtcrafting3.dollar.exception.DollarException;
import de.siphalor.nbtcrafting3.dollar.exception.UnresolvedDollarReferenceException;
import de.siphalor.nbtcrafting3.dollar.reference.MapBackedReferenceResolver;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;
import de.siphalor.nbtcrafting3.ingredient.IIngredient;
import java.util.HashMap;
import java.util.List;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.recipe.Ingredient;
import net.minecraft.util.ItemScatterer;
import net.minecraft.util.collection.DefaultedList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RecipeUtil {
    @Deprecated
    public static ItemStack getDollarAppliedOutputStack(ItemStack baseOutput, DefaultedList<Ingredient> ingredients, Inventory inventory) {
        return RecipeUtil.getDollarAppliedResult(baseOutput, ingredients, inventory);
    }

    public static ItemStack getDollarAppliedResult(ItemStack baseOutput, DefaultedList<Ingredient> ingredients, Inventory inventory) {
        ItemStack stack = baseOutput.copy();
        Dollar[] dollars = DollarExtractor.extractDollars(stack.getTag(), true);
        if (dollars.length > 0) {
            return RecipeUtil.applyDollars(stack, dollars, RecipeUtil.buildReferenceResolverFromResolvedIngredients(RecipeUtil.resolveIngredients(ingredients, inventory), inventory));
        }
        return stack;
    }

    public static ReferenceResolver buildReferenceResolverFromResolvedIngredients(int[] resolvedIngredientStacks, Inventory inventory) {
        HashMap<String, Object> reference = new HashMap<String, Object>();
        for (int i = 0; i < resolvedIngredientStacks.length; ++i) {
            int resolvedIngredientStack = resolvedIngredientStacks[i];
            if (resolvedIngredientStack == -1) continue;
            reference.put("i" + i, inventory.getStack(resolvedIngredientStack));
        }
        return new MapBackedReferenceResolver(reference);
    }

    public static int[] resolveIngredients(List<Ingredient> ingredients, Inventory inventory) {
        int i;
        int ingredientMatchesOffset;
        Ingredient ingredient;
        int j;
        int ingredientCount = ingredients.size();
        int inventorySize = inventory.size();
        int[] resolvedIngredientStacks = new int[ingredientCount];
        boolean[] stackMatchesToAnything = new boolean[inventorySize];
        byte[] matches = new byte[ingredientCount * inventorySize];
        boolean advancedMatchingRequired = false;
        for (j = 0; j < ingredientCount; ++j) {
            block9: {
                ingredient = ingredients.get(j);
                ingredientMatchesOffset = j * inventorySize;
                for (i = 0; i < inventorySize; ++i) {
                    if (stackMatchesToAnything[i]) continue;
                    if (!ingredient.test(inventory.getStack(i))) {
                        matches[ingredientMatchesOffset + i] = -1;
                        continue;
                    }
                    break block9;
                }
                advancedMatchingRequired = true;
                break;
            }
            resolvedIngredientStacks[j] = i;
            matches[ingredientMatchesOffset + i] = 1;
            stackMatchesToAnything[i] = true;
        }
        if (!advancedMatchingRequired) {
            return resolvedIngredientStacks;
        }
        for (j = 0; j < ingredientCount; ++j) {
            ingredient = ingredients.get(j);
            ingredientMatchesOffset = j * inventorySize;
            for (i = 0; i < inventorySize; ++i) {
                if (matches[ingredientMatchesOffset + i] != 0) continue;
                matches[ingredientMatchesOffset + i] = ingredient.test(inventory.getStack(i)) ? 1 : -1;
            }
        }
        int currentIngredient = 0;
        int[] ingredientStackIndices = new int[ingredientCount];
        boolean[] usedStacks = new boolean[inventorySize];
        ingredientStackIndices[0] = inventorySize;
        block4: while (true) {
            int ingredientMatchesOffset2 = currentIngredient * inventorySize;
            int ingredientStackIndex = ingredientStackIndices[currentIngredient];
            do {
                if (--ingredientStackIndex >= 0) continue;
                if (--currentIngredient < 0) {
                    NbtCrafting.logWarn("Failed to build reference map dynamically for recipe! Please report this on the Nbt Crafting issue tracker!");
                    break block4;
                }
                usedStacks[ingredientStackIndices[currentIngredient]] = false;
                continue block4;
            } while (usedStacks[ingredientStackIndex] || matches[ingredientMatchesOffset2 + ingredientStackIndex] != 1);
            ingredientStackIndices[currentIngredient] = ingredientStackIndex;
            usedStacks[ingredientStackIndex] = true;
            if (++currentIngredient >= ingredientCount) break;
            ingredientStackIndices[currentIngredient] = inventorySize;
        }
        return ingredientStackIndices;
    }

    @Deprecated
    public static ItemStack getDollarAppliedOutputStack(ItemStack baseOutput, Ingredient ingredient, Inventory inventory) {
        return RecipeUtil.getDollarAppliedResult(baseOutput, ingredient, inventory);
    }

    public static ItemStack getDollarAppliedResult(ItemStack baseOutput, Ingredient ingredient, Inventory inventory) {
        return RecipeUtil.getDollarAppliedResult(baseOutput, ingredient, "this", inventory);
    }

    @Deprecated
    public static ItemStack getDollarAppliedOutputStack(ItemStack baseOutput, Ingredient ingredient, String referenceName, Inventory inventory) {
        return RecipeUtil.getDollarAppliedResult(baseOutput, ingredient, referenceName, inventory);
    }

    public static ItemStack getDollarAppliedResult(ItemStack baseOutput, Ingredient ingredient, String referenceName, Inventory inventory) {
        ItemStack stack = baseOutput.copy();
        Dollar[] dollars = DollarExtractor.extractDollars(stack.getTag(), true);
        if (dollars.length > 0) {
            return RecipeUtil.applyDollars(stack, dollars, ref -> {
                if (ref.equals(referenceName)) {
                    return inventory.getStack(0);
                }
                throw new UnresolvedDollarReferenceException(ref);
            });
        }
        return stack;
    }

    public static ItemStack getRemainder(ItemStack itemStack, Ingredient ingredient, ReferenceResolver referenceResolver) {
        ItemStack result = ((IIngredient)ingredient).nbtCrafting3$getRecipeRemainder(itemStack, referenceResolver);
        if (result == null) {
            return new ItemStack((ItemConvertible)itemStack.getItem().getRecipeRemainder());
        }
        return result;
    }

    public static void putRemainders(DefaultedList<ItemStack> remainders, Inventory target, World world, BlockPos scatterPos) {
        RecipeUtil.putRemainders(remainders, target, world, scatterPos, 0);
    }

    public static void putRemainders(DefaultedList<ItemStack> remainders, Inventory target, World world, BlockPos scatterPos, int offset) {
        int size = remainders.size();
        if (size > target.size()) {
            throw new IllegalArgumentException("Size of given remainder list must be <= size of target inventory");
        }
        for (int i = 0; i < size; ++i) {
            if (!target.getStack(offset + i).isEmpty()) continue;
            target.setStack(offset + i, (ItemStack)remainders.get(i));
            remainders.set(i, (Object)ItemStack.EMPTY);
        }
        ItemScatterer.spawn((World)world, (BlockPos)scatterPos, remainders);
    }

    public static ItemStack applyDollars(ItemStack stack, Dollar[] dollars, ReferenceResolver referenceResolver) {
        for (Dollar dollar : dollars) {
            try {
                dollar.apply(stack, referenceResolver);
            }
            catch (DollarException e) {
                e.printStackTrace();
            }
        }
        if (stack.getDamage() > stack.getMaxDamage()) {
            return ItemStack.EMPTY;
        }
        return stack;
    }
}

